/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.Builder;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webserver.Router;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.testing.junit5.DirectClientConnection;
import io.helidon.webserver.testing.junit5.DirectPeerInfo;
import io.helidon.webserver.testing.junit5.DirectSocket;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Optional;

public class DirectClient
implements Http1Client {
    private final HttpRouting routing;
    private final Http1Client httpClient;
    private String clientHost;
    private int clientPort;
    private Principal clientTlsPrincipal;
    private Certificate[] clientTlsCertificates;
    private String serverHost;
    private int serverPort;
    private Principal serverTlsPrincipal;
    private Certificate[] serverTlsCertificates;
    private boolean isTls;
    private Router router;

    public DirectClient(HttpRouting.Builder routing) {
        this.routing = (HttpRouting)routing.build();
        this.httpClient = ((Http1ClientConfig.Builder)Http1Client.builder().baseUri(URI.create("http://helidon-unit:65000"))).build();
        this.router = (Router)((Router.Builder)Router.builder().addRouting((Builder)routing)).build();
    }

    public Http1ClientConfig prototype() {
        return Http1ClientConfig.create();
    }

    public Http1ClientRequest method(Method method) {
        if (this.clientHost == null) {
            this.clientHost = "localhost";
        }
        if (this.clientPort == 0) {
            this.clientPort = 64000;
        }
        if (this.serverPort == 0) {
            this.serverPort = 8080;
        }
        if (this.serverHost == null) {
            this.serverHost = "localhost";
        }
        DirectPeerInfo clientPeer = new DirectPeerInfo(InetSocketAddress.createUnresolved(this.clientHost, this.clientPort), this.clientHost, this.clientPort, Optional.ofNullable(this.clientTlsPrincipal), Optional.ofNullable(this.clientTlsCertificates));
        DirectPeerInfo localPeer = new DirectPeerInfo(InetSocketAddress.createUnresolved(this.serverHost, this.serverPort), this.serverHost, this.serverPort, Optional.ofNullable(this.serverTlsPrincipal), Optional.ofNullable(this.serverTlsCertificates));
        DirectSocket socket = DirectSocket.create(localPeer, clientPeer, this.isTls);
        return (Http1ClientRequest)((Http1ClientRequest)this.httpClient.method(method)).connection((ClientConnection)new DirectClientConnection(socket, this.router));
    }

    public DirectClient setTls(boolean tls) {
        this.isTls = tls;
        return this;
    }

    public DirectClient clientHost(String clientHost) {
        this.clientHost = clientHost;
        return this;
    }

    public DirectClient clientPort(int clientPort) {
        this.clientPort = clientPort;
        return this;
    }

    public DirectClient clientTlsPrincipal(Principal clientTlsPrincipal) {
        this.clientTlsPrincipal = clientTlsPrincipal;
        return this;
    }

    public DirectClient clientTlsCertificates(Certificate[] clientTlsCertificates) {
        this.clientTlsCertificates = clientTlsCertificates;
        return this;
    }

    public DirectClient serverHost(String serverHost) {
        this.serverHost = serverHost;
        return this;
    }

    public DirectClient serverPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public DirectClient serverTlsPrincipal(Principal serverTlsPrincipal) {
        this.serverTlsPrincipal = serverTlsPrincipal;
        return this;
    }

    public DirectClient serverTlsCertificates(Certificate[] serverTlsCertificates) {
        this.serverTlsCertificates = serverTlsCertificates;
        return this;
    }

    public void close() {
        this.router.afterStop();
    }
}

