/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.websocket;

import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.webclient.websocket.WsClient;
import io.helidon.webclient.websocket.WsClientConfig;
import io.helidon.webserver.testing.junit5.websocket.DirectWsConnection;
import io.helidon.webserver.websocket.WsRoute;
import io.helidon.webserver.websocket.WsRouting;
import io.helidon.websocket.WsListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class DirectWsClient
implements WsClient {
    private final List<DirectWsConnection> connections = new ArrayList<DirectWsConnection>();
    private final WsRouting routing;

    private DirectWsClient(WsRouting routing) {
        this.routing = routing;
        routing.beforeStart();
    }

    public static DirectWsClient create(WsRouting routing) {
        return new DirectWsClient(routing);
    }

    public void connect(URI uri, WsListener clientListener) {
        HttpPrologue prologue = HttpPrologue.create((String)"ws", (String)"ws", (String)"13", (Method)Method.GET, (String)uri.getRawPath(), (boolean)false);
        WsRoute route = this.routing.findRoute(prologue);
        DirectWsConnection directWsConnection = DirectWsConnection.create(prologue, clientListener, route);
        directWsConnection.start();
        this.connections.add(directWsConnection);
    }

    public void connect(String path, WsListener listener) {
        try {
            this.connect(new URI("ws", null, "helidon-unit", 65000, path, null, null), listener);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create URI from provided path", e);
        }
    }

    public WsClientConfig prototype() {
        return WsClientConfig.create();
    }

    void close() {
        this.connections.forEach(DirectWsConnection::stop);
        this.routing.afterStop();
    }
}

