/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.websocket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.PeerInfo;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.WritableHeaders;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.websocket.ClientWsConnection;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.testing.junit5.DirectPeerInfo;
import io.helidon.webserver.testing.junit5.DirectSocket;
import io.helidon.webserver.testing.junit5.websocket.DirectWsServerContext;
import io.helidon.webserver.websocket.WsConnection;
import io.helidon.webserver.websocket.WsRoute;
import io.helidon.websocket.WsListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

class DirectWsConnection {
    private final AtomicBoolean serverStarted = new AtomicBoolean();
    private final HttpPrologue prologue;
    private final WsListener clientListener;
    private final WsRoute serverRoute;
    private final DataReader clientReader;
    private final DataWriter clientWriter;
    private final DataReader serverReader;
    private final DataWriter serverWriter;
    private final HelidonSocket socket;
    private final ConnectionContext ctx;
    private final ExecutorService executorService;
    private volatile Future<?> serverFuture;
    private volatile Future<?> clientFuture;

    DirectWsConnection(HttpPrologue prologue, WsListener clientListener, WsRoute serverRoute) {
        this.prologue = prologue;
        this.clientListener = clientListener;
        this.serverRoute = serverRoute;
        this.executorService = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("direct-test-ws", 1L).factory());
        ArrayBlockingQueue<byte[]> serverToClient = new ArrayBlockingQueue<byte[]>(1024);
        ArrayBlockingQueue<byte[]> clientToServer = new ArrayBlockingQueue<byte[]>(1024);
        this.clientReader = DirectWsConnection.reader(serverToClient);
        this.clientWriter = this.writer(clientToServer);
        this.serverReader = DirectWsConnection.reader(clientToServer);
        this.serverWriter = this.writer(serverToClient);
        DirectPeerInfo info = new DirectPeerInfo((SocketAddress)InetSocketAddress.createUnresolved("localhost", 64000), "localhost", 64000, Optional.empty(), Optional.empty());
        this.socket = DirectSocket.create((PeerInfo)info, (PeerInfo)info, (boolean)false);
        this.ctx = new DirectWsServerContext(this.executorService, (Router)Router.builder().build(), this.socket, this.serverWriter, this.serverReader);
    }

    static DirectWsConnection create(HttpPrologue prologue, WsListener clientListener, WsRoute serverRoute) {
        return new DirectWsConnection(prologue, clientListener, serverRoute);
    }

    private static DataReader reader(ArrayBlockingQueue<byte[]> queue) {
        return new DataReader(() -> {
            byte[] data;
            try {
                data = (byte[])queue.take();
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread interrupted", e);
            }
            if (data.length == 0) {
                return null;
            }
            return data;
        });
    }

    void start() {
        if (this.serverStarted.compareAndSet(false, true)) {
            WsConnection serverConnection = WsConnection.create((ConnectionContext)this.ctx, (HttpPrologue)this.prologue, (Headers)WritableHeaders.create(), (String)"", (WsRoute)this.serverRoute);
            ClientWsConnection clientConnection = ClientWsConnection.create((ClientConnection)new DirectConnect(this.clientReader, this.clientWriter), (WsListener)this.clientListener);
            this.serverFuture = this.executorService.submit(() -> serverConnection.handle(new Semaphore(1024)));
            this.clientFuture = this.executorService.submit((Runnable)clientConnection);
        }
    }

    void stop() {
        Future<?> s = this.serverFuture;
        Future<?> c = this.clientFuture;
        if (s != null) {
            s.cancel(true);
        }
        if (c != null) {
            c.cancel(true);
        }
    }

    private DataWriter writer(final ArrayBlockingQueue<byte[]> queue) {
        return new DataWriter(){

            public void write(BufferData ... buffers) {
                this.writeNow(buffers);
            }

            public void write(BufferData buffer) {
                this.writeNow(buffer);
            }

            public void writeNow(BufferData ... buffers) {
                for (BufferData buffer : buffers) {
                    this.writeNow(buffer);
                }
            }

            public void writeNow(BufferData buffer) {
                byte[] bytes = new byte[buffer.available()];
                buffer.read(bytes);
                try {
                    queue.put(bytes);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Thread interrupted", e);
                }
            }
        };
    }

    private static class DirectConnect
    implements ClientConnection {
        private final DataReader reader;
        private final DataWriter writer;
        private final PeerInfo clientPeer;
        private final PeerInfo localPeer;
        private final HelidonSocket socket;

        private DirectConnect(DataReader reader, DataWriter writer) {
            this.reader = reader;
            this.writer = writer;
            String clientHost = "localhost";
            int clientPort = 9999;
            String serverHost = "server";
            int serverPort = 9999;
            this.clientPeer = new DirectPeerInfo((SocketAddress)InetSocketAddress.createUnresolved(clientHost, clientPort), clientHost, clientPort, Optional.empty(), Optional.empty());
            this.localPeer = new DirectPeerInfo((SocketAddress)InetSocketAddress.createUnresolved(serverHost, serverPort), serverHost, serverPort, Optional.empty(), Optional.empty());
            this.socket = DirectSocket.create((PeerInfo)this.localPeer, (PeerInfo)this.clientPeer, (boolean)false);
        }

        public DataReader reader() {
            return this.reader;
        }

        public DataWriter writer() {
            return this.writer;
        }

        public String channelId() {
            return "direct-ws-connection";
        }

        public HelidonSocket helidonSocket() {
            return this.socket;
        }

        public void readTimeout(Duration readTimeout) {
        }

        public void closeResource() {
        }
    }
}

