/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.http2;

import io.helidon.webclient.http2.Http2Client;
import io.helidon.webclient.http2.Http2ClientConfig;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.http2.Http2TestClient;
import io.helidon.webserver.testing.junit5.spi.ServerJunitExtension;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.util.Set;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class Http2ServerExtension
implements ServerJunitExtension {
    private static final Set<Class<?>> SUPPORTED = Set.of(Http2Client.class, Http2TestClient.class);

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> parameterType, WebServer server) {
        String socketName = Junit5Util.socketName((Parameter)parameterContext.getParameter());
        URI uri = URI.create("http://localhost:" + server.port(socketName));
        if (Http2Client.class.equals(parameterType)) {
            return ((Http2ClientConfig.Builder)Http2Client.builder().baseUri(uri)).build();
        }
        if (Http2TestClient.class.equals(parameterType)) {
            Http2TestClient client = new Http2TestClient(uri);
            extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)Http2TestClient.class.getName(), (Object)client);
            return client;
        }
        throw new ParameterResolutionException("HTTP/2 extension only supports Http2Client parameter type");
    }

    public void afterEach(ExtensionContext context) {
        super.afterEach(context);
        Http2TestClient client = (Http2TestClient)context.getStore(ExtensionContext.Namespace.GLOBAL).remove((Object)Http2TestClient.class.getName());
        if (client != null) {
            client.close();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return SUPPORTED.contains(parameterContext.getParameter().getType());
    }
}

