/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

class ByteBufRequestChunk
implements DataChunk {
    private static final boolean IS_GRAAL_VM = Boolean.getBoolean("com.oracle.graalvm.isaot");
    private static final Logger LOGGER = Logger.getLogger(ByteBufRequestChunk.class.getName());
    private static final AtomicLong ID_INCREMENTER = new AtomicLong(1L);
    private final long id = ID_INCREMENTER.getAndIncrement();
    private final ByteBuffer[] byteBuffers;
    private final ReferenceHoldingQueue.ReleasableReference<DataChunk> ref;

    ByteBufRequestChunk(ByteBuf byteBuf, ReferenceHoldingQueue<DataChunk> referenceHoldingQueue) {
        Objects.requireNonNull(byteBuf, "The ByteBuf must not be null!");
        this.byteBuffers = new ByteBuffer[]{byteBuf.nioBuffer().asReadOnlyBuffer()};
        this.ref = new ReferenceHoldingQueue.ReleasableReference<DataChunk>((DataChunk)this, referenceHoldingQueue, () -> ((ByteBuf)byteBuf).release());
        byteBuf.retain();
    }

    public boolean isReleased() {
        return this.ref.isReleased();
    }

    public ByteBuffer[] data() {
        if (this.isReleased()) {
            throw new IllegalStateException("The request chunk was already released!");
        }
        return this.byteBuffers;
    }

    public void release() {
        this.ref.release();
    }

    public long id() {
        return this.id;
    }

    protected void finalize() {
        if (!this.isReleased()) {
            OneTimeLoggerHolder.logOnce();
            this.release();
        }
    }

    static void logLeak() {
        LOGGER.warning("LEAK: RequestChunk.release() was not called before it was garbage collected. While the Reactive WebServer is designed to automatically release all the RequestChunks, it still comes with a considerable performance penalty and a demand for a large memory space (depending on expected throughput, it might require even more than 2GB). As such the users are strongly advised to release all the RequestChunk instances explicitly when they're not needed.");
    }

    static class OneTimeLoggerHolder {
        private static final AtomicBoolean LOGGED = new AtomicBoolean();

        private OneTimeLoggerHolder() {
        }

        static void logOnce() {
            if (IS_GRAAL_VM && LOGGED.compareAndSet(false, true)) {
                ByteBufRequestChunk.logLeak();
            }
        }

        static {
            if (!IS_GRAAL_VM) {
                ByteBufRequestChunk.logLeak();
            }
        }
    }

    static class DataChunkHoldingQueue
    extends ReferenceHoldingQueue<DataChunk> {
        DataChunkHoldingQueue() {
        }

        @Override
        protected void hookOnAutoRelease() {
            OneTimeLoggerHolder.logOnce();
        }
    }
}

