/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.webserver.BareRequest;
import io.helidon.webserver.BareResponse;
import io.helidon.webserver.Routing;
import io.helidon.webserver.websocket.WebSocketRoute;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class WebSocketRouting
implements Routing {
    private final Set<Extension> extensions;
    private final List<WebSocketRoute> routes;
    private final ExecutorService executorService;

    private WebSocketRouting(Builder builder) {
        this.routes = builder.routes;
        this.extensions = builder.extensions;
        this.executorService = builder.executorService;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void route(BareRequest bareRequest, BareResponse bareResponse) {
        throw new UnsupportedOperationException("Not used in case of websocket routing");
    }

    Set<Extension> getExtensions() {
        return this.extensions;
    }

    List<WebSocketRoute> getRoutes() {
        return this.routes;
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Routing> {
        private final List<WebSocketRoute> routes = new ArrayList<WebSocketRoute>();
        private final Set<Extension> extensions = new HashSet<Extension>();
        private ExecutorService executorService;

        private Builder() {
        }

        public Builder endpoint(String path, Class<?> endpointClass) {
            this.routes.add(new WebSocketRoute(path, endpointClass, null));
            return this;
        }

        public Builder endpoint(Class<?> endpointClass) {
            this.routes.add(new WebSocketRoute("/", endpointClass, null));
            return this;
        }

        public Builder endpoint(String path, ServerEndpointConfig serverEndpointConfig) {
            this.routes.add(new WebSocketRoute(path, null, serverEndpointConfig));
            return this;
        }

        public Builder endpoint(ServerEndpointConfig serverEndpointConfig) {
            this.routes.add(new WebSocketRoute("/", null, serverEndpointConfig));
            return this;
        }

        public Builder extension(Extension extension) {
            this.extensions.add(extension);
            return this;
        }

        public Builder executor(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public WebSocketRouting build() {
            return new WebSocketRouting(this);
        }
    }
}

