/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webserver.staticcontent.TemporaryStorage;
import io.helidon.webserver.staticcontent.TemporaryStorageConfigBlueprint;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.staticcontent.TemporaryStorageConfigBlueprint")
public interface TemporaryStorageConfig
extends TemporaryStorageConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TemporaryStorageConfig instance) {
        return (Builder)TemporaryStorageConfig.builder().from(instance);
    }

    public static TemporaryStorageConfig create(Config config) {
        return ((Builder)TemporaryStorageConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static TemporaryStorageConfig create(io.helidon.common.config.Config config) {
        return TemporaryStorageConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static TemporaryStorageConfig create() {
        return TemporaryStorageConfig.builder().buildPrototype();
    }

    @Override
    public boolean enabled();

    @Override
    public Optional<Path> directory();

    @Override
    public String filePrefix();

    @Override
    public String fileSuffix();

    @Override
    public boolean deleteOnExit();

    public static class Builder
    extends BuilderBase<Builder, TemporaryStorageConfig>
    implements io.helidon.common.Builder<Builder, TemporaryStorage> {
        private Builder() {
        }

        public TemporaryStorageConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TemporaryStorageConfigImpl(this);
        }

        public TemporaryStorage build() {
            return TemporaryStorage.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TemporaryStorageConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean deleteOnExit = true;
        private boolean enabled = true;
        private Config config;
        private Path directory;
        private String filePrefix = "helidon-ws";
        private String fileSuffix = ".je";

        protected BuilderBase() {
        }

        public BUILDER from(TemporaryStorageConfig prototype) {
            this.enabled(prototype.enabled());
            this.directory(prototype.directory());
            this.filePrefix(prototype.filePrefix());
            this.fileSuffix(prototype.fileSuffix());
            this.deleteOnExit(prototype.deleteOnExit());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            builder.directory().ifPresent(this::directory);
            this.filePrefix(builder.filePrefix());
            this.fileSuffix(builder.fileSuffix());
            this.deleteOnExit(builder.deleteOnExit());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("directory").as(Path.class).ifPresent(this::directory);
            config.get("file-prefix").as(String.class).ifPresent(this::filePrefix);
            config.get("file-suffix").as(String.class).ifPresent(this::fileSuffix);
            config.get("delete-on-exit").as(Boolean.class).ifPresent(this::deleteOnExit);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDirectory() {
            this.directory = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER directory(Path directory) {
            Objects.requireNonNull(directory);
            this.directory = directory;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER filePrefix(String filePrefix) {
            Objects.requireNonNull(filePrefix);
            this.filePrefix = filePrefix;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fileSuffix(String fileSuffix) {
            Objects.requireNonNull(fileSuffix);
            this.fileSuffix = fileSuffix;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deleteOnExit(boolean deleteOnExit) {
            this.deleteOnExit = deleteOnExit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<Path> directory() {
            return Optional.ofNullable(this.directory);
        }

        public String filePrefix() {
            return this.filePrefix;
        }

        public String fileSuffix() {
            return this.fileSuffix;
        }

        public boolean deleteOnExit() {
            return this.deleteOnExit;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "TemporaryStorageConfigBuilder{enabled=" + this.enabled + ",directory=" + String.valueOf(this.directory) + ",filePrefix=" + this.filePrefix + ",fileSuffix=" + this.fileSuffix + ",deleteOnExit=" + this.deleteOnExit + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER directory(Optional<? extends Path> directory) {
            Objects.requireNonNull(directory);
            this.directory = directory.map(Path.class::cast).orElse(this.directory);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class TemporaryStorageConfigImpl
        implements TemporaryStorageConfig,
        Supplier<TemporaryStorage> {
            private final boolean deleteOnExit;
            private final boolean enabled;
            private final Optional<Path> directory;
            private final String filePrefix;
            private final String fileSuffix;

            protected TemporaryStorageConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.directory = builder.directory().map(Function.identity());
                this.filePrefix = builder.filePrefix();
                this.fileSuffix = builder.fileSuffix();
                this.deleteOnExit = builder.deleteOnExit();
            }

            public TemporaryStorage build() {
                return TemporaryStorage.create(this);
            }

            @Override
            public TemporaryStorage get() {
                return this.build();
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public Optional<Path> directory() {
                return this.directory;
            }

            @Override
            public String filePrefix() {
                return this.filePrefix;
            }

            @Override
            public String fileSuffix() {
                return this.fileSuffix;
            }

            @Override
            public boolean deleteOnExit() {
                return this.deleteOnExit;
            }

            public String toString() {
                return "TemporaryStorageConfig{enabled=" + this.enabled + ",directory=" + String.valueOf(this.directory) + ",filePrefix=" + this.filePrefix + ",fileSuffix=" + this.fileSuffix + ",deleteOnExit=" + this.deleteOnExit + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TemporaryStorageConfig)) {
                    return false;
                }
                TemporaryStorageConfig other = (TemporaryStorageConfig)o;
                return this.enabled == other.enabled() && Objects.equals(this.directory, other.directory()) && Objects.equals(this.filePrefix, other.filePrefix()) && Objects.equals(this.fileSuffix, other.fileSuffix()) && this.deleteOnExit == other.deleteOnExit();
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.directory, this.filePrefix, this.fileSuffix, this.deleteOnExit);
            }
        }
    }
}

