/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.http.Method;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.ClassPathContentHandler;
import io.helidon.webserver.staticcontent.ClasspathHandlerConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

class SingleFileClassPathContentHandler
extends ClassPathContentHandler {
    private static final System.Logger LOGGER = System.getLogger(SingleFileClassPathContentHandler.class.getName());
    private final AtomicBoolean populatedInMemoryCache = new AtomicBoolean();
    private final boolean cacheInMemory;
    private final String location;
    private final ClassLoader classLoader;

    SingleFileClassPathContentHandler(ClasspathHandlerConfig config) {
        super(config);
        this.cacheInMemory = config.cachedFiles().contains(".") || config.cachedFiles().contains("/");
        this.location = SingleFileClassPathContentHandler.cleanRoot(config.location());
        this.classLoader = config.classLoader().or(() -> Optional.ofNullable(Thread.currentThread().getContextClassLoader())).orElseGet(SingleFileClassPathContentHandler.class::getClassLoader);
    }

    @Override
    public void beforeStart() {
        try {
            URL resourceUrl = this.classLoader.getResource(this.location);
            if (resourceUrl == null) {
                throw new IllegalArgumentException("Resource " + this.location + " cannot be added to in memory cache, as it does not exist on classpath for single file classpath static content handler.");
            }
            if (this.cacheInMemory && this.populatedInMemoryCache.compareAndSet(false, true)) {
                this.addToInMemoryCache(this.location, resourceUrl);
            } else {
                Optional<CachedHandler> handler = this.cachedHandler(this.location, resourceUrl);
                if (handler.isEmpty()) {
                    throw new IllegalArgumentException("Resource " + this.location + " cannot be added to in memory cache, as it does not exist on classpath for single file classpath static content handler.");
                }
                this.cacheHandler(this.location, handler.get());
            }
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.WARNING, "Failed to add classpath resource to in-memory cache, location: " + this.location, (Throwable)e);
        }
        super.beforeStart();
    }

    @Override
    void releaseCache() {
        this.populatedInMemoryCache.set(false);
    }

    @Override
    boolean doHandle(Method method, String requestedPath, ServerRequest request, ServerResponse response, boolean mapped) throws IOException {
        CachedHandler handler = this.cacheHandler(this.location).orElseThrow(() -> new IllegalStateException("Handler must be cached during startup " + this.location));
        return handler.handle(this.handlerCache(), method, request, response, requestedPath);
    }
}

