/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webserver.staticcontent.BaseHandlerConfig;
import io.helidon.webserver.staticcontent.FileSystemHandlerConfigBlueprint;
import io.helidon.webserver.staticcontent.StaticContentConfigSupport;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.staticcontent.FileSystemHandlerConfigBlueprint")
public interface FileSystemHandlerConfig
extends FileSystemHandlerConfigBlueprint,
Prototype.Api,
BaseHandlerConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FileSystemHandlerConfig instance) {
        return (Builder)FileSystemHandlerConfig.builder().from(instance);
    }

    public static FileSystemHandlerConfig create(Config config) {
        return ((Builder)FileSystemHandlerConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static FileSystemHandlerConfig create(io.helidon.common.config.Config config) {
        return FileSystemHandlerConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static FileSystemHandlerConfig create() {
        return FileSystemHandlerConfig.builder().buildPrototype();
    }

    public static FileSystemHandlerConfig create(Path location) {
        return StaticContentConfigSupport.FileSystemMethods.create(location);
    }

    @Override
    public Path location();

    public static class Builder
    extends BuilderBase<Builder, FileSystemHandlerConfig>
    implements io.helidon.common.Builder<Builder, FileSystemHandlerConfig> {
        private Builder() {
        }

        public FileSystemHandlerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.FileSystemHandlerConfigImpl(this);
        }

        public FileSystemHandlerConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends FileSystemHandlerConfig>
    extends BaseHandlerConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private Path location;

        protected BuilderBase() {
        }

        public BUILDER from(FileSystemHandlerConfig prototype) {
            super.from(prototype);
            this.location(prototype.location());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.location().ifPresent(this::location);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("location").as(Path.class).ifPresent(this::location);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER location(Path location) {
            Objects.requireNonNull(location);
            this.location = location;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Path> location() {
            return Optional.ofNullable(this.location);
        }

        @Override
        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        @Override
        public String toString() {
            return "FileSystemHandlerConfigBuilder{location=" + String.valueOf(this.location) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.location == null) {
                collector.fatal(this.getClass(), "Property \"location\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class FileSystemHandlerConfigImpl
        extends BaseHandlerConfig.BuilderBase.BaseHandlerConfigImpl
        implements FileSystemHandlerConfig {
            private final Path location;

            protected FileSystemHandlerConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.location = builder.location().get();
            }

            @Override
            public Path location() {
                return this.location;
            }

            @Override
            public String toString() {
                return "FileSystemHandlerConfig{location=" + String.valueOf(this.location) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FileSystemHandlerConfig)) {
                    return false;
                }
                FileSystemHandlerConfig other = (FileSystemHandlerConfig)o;
                return super.equals(other) && Objects.equals(this.location, other.location());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.location);
            }
        }
    }
}

