/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webserver.staticcontent.BaseHandlerConfig;
import io.helidon.webserver.staticcontent.ClasspathHandlerConfigBlueprint;
import io.helidon.webserver.staticcontent.StaticContentConfigSupport;
import io.helidon.webserver.staticcontent.TemporaryStorage;
import io.helidon.webserver.staticcontent.TemporaryStorageConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.staticcontent.ClasspathHandlerConfigBlueprint")
public interface ClasspathHandlerConfig
extends ClasspathHandlerConfigBlueprint,
Prototype.Api,
BaseHandlerConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClasspathHandlerConfig instance) {
        return (Builder)ClasspathHandlerConfig.builder().from(instance);
    }

    public static ClasspathHandlerConfig create(Config config) {
        return ((Builder)ClasspathHandlerConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static ClasspathHandlerConfig create(io.helidon.common.config.Config config) {
        return ClasspathHandlerConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static ClasspathHandlerConfig create() {
        return ClasspathHandlerConfig.builder().buildPrototype();
    }

    public static ClasspathHandlerConfig create(String location) {
        return StaticContentConfigSupport.ClasspathMethods.create(location);
    }

    @Override
    public String location();

    @Override
    public Optional<TemporaryStorage> temporaryStorage();

    @Override
    public Optional<ClassLoader> classLoader();

    @Override
    public boolean singleFile();

    public static class Builder
    extends BuilderBase<Builder, ClasspathHandlerConfig>
    implements io.helidon.common.Builder<Builder, ClasspathHandlerConfig> {
        private Builder() {
        }

        public ClasspathHandlerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ClasspathHandlerConfigImpl(this);
        }

        public ClasspathHandlerConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ClasspathHandlerConfig>
    extends BaseHandlerConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean singleFile;
        private ClassLoader classLoader;
        private Config config;
        private String location;
        private TemporaryStorage temporaryStorage;

        protected BuilderBase() {
        }

        public BUILDER from(ClasspathHandlerConfig prototype) {
            super.from(prototype);
            this.location(prototype.location());
            this.temporaryStorage(prototype.temporaryStorage());
            this.classLoader(prototype.classLoader());
            this.singleFile(prototype.singleFile());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.location().ifPresent(this::location);
            builder.temporaryStorage().ifPresent(this::temporaryStorage);
            builder.classLoader().ifPresent(this::classLoader);
            this.singleFile(builder.singleFile());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("location").as(String.class).ifPresent(this::location);
            config.get("temporary-storage").as(TemporaryStorageConfig::create).ifPresent(this::temporaryStorage);
            config.get("single-file").as(Boolean.class).ifPresent(this::singleFile);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER location(String location) {
            Objects.requireNonNull(location);
            this.location = location;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTemporaryStorage() {
            this.temporaryStorage = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temporaryStorage(TemporaryStorage temporaryStorage) {
            Objects.requireNonNull(temporaryStorage);
            this.temporaryStorage = temporaryStorage;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temporaryStorage(TemporaryStorageConfig temporaryStorageConfig) {
            Objects.requireNonNull(temporaryStorageConfig);
            this.temporaryStorage = TemporaryStorage.create(temporaryStorageConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temporaryStorage(Consumer<TemporaryStorageConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TemporaryStorageConfig.Builder builder = TemporaryStorageConfig.builder();
            consumer.accept(builder);
            this.temporaryStorage(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearClassLoader() {
            this.classLoader = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER classLoader(ClassLoader classLoader) {
            Objects.requireNonNull(classLoader);
            this.classLoader = classLoader;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER singleFile(boolean singleFile) {
            this.singleFile = singleFile;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> location() {
            return Optional.ofNullable(this.location);
        }

        public Optional<TemporaryStorage> temporaryStorage() {
            return Optional.ofNullable(this.temporaryStorage);
        }

        public Optional<ClassLoader> classLoader() {
            return Optional.ofNullable(this.classLoader);
        }

        public boolean singleFile() {
            return this.singleFile;
        }

        @Override
        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        @Override
        public String toString() {
            return "ClasspathHandlerConfigBuilder{location=" + this.location + ",temporaryStorage=" + String.valueOf(this.temporaryStorage) + ",classLoader=" + String.valueOf(this.classLoader) + ",singleFile=" + this.singleFile + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.location == null) {
                collector.fatal(this.getClass(), "Property \"location\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER temporaryStorage(Optional<? extends TemporaryStorage> temporaryStorage) {
            Objects.requireNonNull(temporaryStorage);
            this.temporaryStorage = temporaryStorage.map(TemporaryStorage.class::cast).orElse(this.temporaryStorage);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER classLoader(Optional<? extends ClassLoader> classLoader) {
            Objects.requireNonNull(classLoader);
            this.classLoader = classLoader.map(ClassLoader.class::cast).orElse(this.classLoader);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ClasspathHandlerConfigImpl
        extends BaseHandlerConfig.BuilderBase.BaseHandlerConfigImpl
        implements ClasspathHandlerConfig {
            private final boolean singleFile;
            private final Optional<TemporaryStorage> temporaryStorage;
            private final Optional<ClassLoader> classLoader;
            private final String location;

            protected ClasspathHandlerConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.location = builder.location().get();
                this.temporaryStorage = builder.temporaryStorage().map(Function.identity());
                this.classLoader = builder.classLoader().map(Function.identity());
                this.singleFile = builder.singleFile();
            }

            @Override
            public String location() {
                return this.location;
            }

            @Override
            public Optional<TemporaryStorage> temporaryStorage() {
                return this.temporaryStorage;
            }

            @Override
            public Optional<ClassLoader> classLoader() {
                return this.classLoader;
            }

            @Override
            public boolean singleFile() {
                return this.singleFile;
            }

            @Override
            public String toString() {
                return "ClasspathHandlerConfig{location=" + this.location + ",temporaryStorage=" + String.valueOf(this.temporaryStorage) + ",classLoader=" + String.valueOf(this.classLoader) + ",singleFile=" + this.singleFile + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ClasspathHandlerConfig)) {
                    return false;
                }
                ClasspathHandlerConfig other = (ClasspathHandlerConfig)o;
                return super.equals(other) && Objects.equals(this.location, other.location()) && Objects.equals(this.temporaryStorage, other.temporaryStorage()) && Objects.equals(this.classLoader, other.classLoader()) && this.singleFile == other.singleFile();
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.location, this.temporaryStorage, this.classLoader, this.singleFile);
            }
        }
    }
}

