/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.media.type.MediaType;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webserver.staticcontent.BaseHandlerConfigBlueprint;
import io.helidon.webserver.staticcontent.MemoryCache;
import io.helidon.webserver.staticcontent.MemoryCacheConfig;
import io.helidon.webserver.staticcontent.StaticContentConfigSupport;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.staticcontent.BaseHandlerConfigBlueprint")
public interface BaseHandlerConfig
extends BaseHandlerConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BaseHandlerConfig instance) {
        return (Builder)BaseHandlerConfig.builder().from(instance);
    }

    @Override
    public boolean enabled();

    @Override
    public String context();

    @Override
    public Set<String> sockets();

    @Override
    public Optional<String> welcome();

    @Override
    public Set<String> cachedFiles();

    @Override
    public Optional<MemoryCache> memoryCache();

    @Override
    public Map<String, MediaType> contentTypes();

    @Override
    public Function<String, String> pathMapper();

    @Override
    public Optional<Integer> recordCacheCapacity();

    public static class Builder
    extends BuilderBase<Builder, BaseHandlerConfig>
    implements io.helidon.common.Builder<Builder, BaseHandlerConfig> {
        private Builder() {
        }

        public BaseHandlerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.BaseHandlerConfigImpl(this);
        }

        public BaseHandlerConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends BaseHandlerConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<String, MediaType> contentTypes = new LinkedHashMap<String, MediaType>();
        private final Set<String> cachedFiles = new LinkedHashSet<String>();
        private final Set<String> sockets = new LinkedHashSet<String>();
        private boolean enabled = true;
        private Config config;
        private Function<String, String> pathMapper = Function.identity();
        private Integer recordCacheCapacity;
        private MemoryCache memoryCache;
        private String context = "/";
        private String welcome;

        protected BuilderBase() {
        }

        public BUILDER from(BaseHandlerConfig prototype) {
            this.enabled(prototype.enabled());
            this.context(prototype.context());
            this.addSockets(prototype.sockets());
            this.welcome(prototype.welcome());
            this.addCachedFiles(prototype.cachedFiles());
            this.memoryCache(prototype.memoryCache());
            this.addContentTypes(prototype.contentTypes());
            this.pathMapper(prototype.pathMapper());
            this.recordCacheCapacity(prototype.recordCacheCapacity());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            this.context(builder.context());
            this.addSockets(builder.sockets);
            builder.welcome().ifPresent(this::welcome);
            this.addCachedFiles(builder.cachedFiles);
            builder.memoryCache().ifPresent(this::memoryCache);
            this.addContentTypes(builder.contentTypes);
            this.pathMapper(builder.pathMapper());
            builder.recordCacheCapacity().ifPresent(this::recordCacheCapacity);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("context").as(String.class).ifPresent(this::context);
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            config.get("welcome").as(String.class).ifPresent(this::welcome);
            config.get("cached-files").asList(String.class).map(Set::copyOf).ifPresent(this::cachedFiles);
            config.get("memory-cache").as(MemoryCacheConfig::create).ifPresent(this::memoryCache);
            config.get("content-types").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.contentTypes.put((String)node.get("name").asString().orElse((Object)node.name()), (MediaType)node.as(StaticContentConfigSupport.BaseMethods::createContentTypes).get())));
            config.get("record-cache-capacity").as(Integer.class).ifPresent(this::recordCacheCapacity);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER context(String context) {
            Objects.requireNonNull(context);
            this.context = context;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocket(String socket) {
            Objects.requireNonNull(socket);
            this.sockets.add(socket);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearWelcome() {
            this.welcome = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER welcome(String welcome) {
            Objects.requireNonNull(welcome);
            this.welcome = welcome;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cachedFiles(Set<String> cachedFiles) {
            Objects.requireNonNull(cachedFiles);
            this.cachedFiles.clear();
            this.cachedFiles.addAll(cachedFiles);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCachedFiles(Set<String> cachedFiles) {
            Objects.requireNonNull(cachedFiles);
            this.cachedFiles.addAll(cachedFiles);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCachedFile(String cachedFile) {
            Objects.requireNonNull(cachedFile);
            this.cachedFiles.add(cachedFile);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMemoryCache() {
            this.memoryCache = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER memoryCache(MemoryCache memoryCache) {
            Objects.requireNonNull(memoryCache);
            this.memoryCache = memoryCache;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER memoryCache(MemoryCacheConfig memoryCacheConfig) {
            Objects.requireNonNull(memoryCacheConfig);
            this.memoryCache = MemoryCache.create(memoryCacheConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER memoryCache(Consumer<MemoryCacheConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            MemoryCacheConfig.Builder builder = MemoryCacheConfig.builder();
            consumer.accept(builder);
            this.memoryCache(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentTypes(Map<String, ? extends MediaType> contentTypes) {
            Objects.requireNonNull(contentTypes);
            this.contentTypes.clear();
            this.contentTypes.putAll(contentTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContentTypes(Map<String, ? extends MediaType> contentTypes) {
            Objects.requireNonNull(contentTypes);
            this.contentTypes.putAll(contentTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putContentType(String key, MediaType contentType) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(contentType);
            this.contentTypes.put(key, contentType);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER pathMapper(Function<String, String> pathMapper) {
            Objects.requireNonNull(pathMapper);
            this.pathMapper = pathMapper;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRecordCacheCapacity() {
            this.recordCacheCapacity = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER recordCacheCapacity(int recordCacheCapacity) {
            Objects.requireNonNull(recordCacheCapacity);
            this.recordCacheCapacity = recordCacheCapacity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public String context() {
            return this.context;
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public Optional<String> welcome() {
            return Optional.ofNullable(this.welcome);
        }

        public Set<String> cachedFiles() {
            return this.cachedFiles;
        }

        public Optional<MemoryCache> memoryCache() {
            return Optional.ofNullable(this.memoryCache);
        }

        public Map<String, MediaType> contentTypes() {
            return this.contentTypes;
        }

        public Function<String, String> pathMapper() {
            return this.pathMapper;
        }

        public Optional<Integer> recordCacheCapacity() {
            return Optional.ofNullable(this.recordCacheCapacity);
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "BaseHandlerConfigBuilder{enabled=" + this.enabled + ",context=" + this.context + ",sockets=" + String.valueOf(this.sockets) + ",welcome=" + this.welcome + ",cachedFiles=" + String.valueOf(this.cachedFiles) + ",memoryCache=" + String.valueOf(this.memoryCache) + ",contentTypes=" + String.valueOf(this.contentTypes) + ",pathMapper=" + String.valueOf(this.pathMapper) + ",recordCacheCapacity=" + this.recordCacheCapacity + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER welcome(Optional<String> welcome) {
            Objects.requireNonNull(welcome);
            this.welcome = welcome.map(String.class::cast).orElse(this.welcome);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER memoryCache(Optional<? extends MemoryCache> memoryCache) {
            Objects.requireNonNull(memoryCache);
            this.memoryCache = memoryCache.map(MemoryCache.class::cast).orElse(this.memoryCache);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER recordCacheCapacity(Optional<Integer> recordCacheCapacity) {
            Objects.requireNonNull(recordCacheCapacity);
            this.recordCacheCapacity = recordCacheCapacity.map(Integer.class::cast).orElse(this.recordCacheCapacity);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class BaseHandlerConfigImpl
        implements BaseHandlerConfig {
            private final boolean enabled;
            private final Function<String, String> pathMapper;
            private final Map<String, MediaType> contentTypes;
            private final Optional<MemoryCache> memoryCache;
            private final Optional<Integer> recordCacheCapacity;
            private final Optional<String> welcome;
            private final Set<String> cachedFiles;
            private final Set<String> sockets;
            private final String context;

            protected BaseHandlerConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.context = builder.context();
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
                this.welcome = builder.welcome().map(Function.identity());
                this.cachedFiles = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.cachedFiles()));
                this.memoryCache = builder.memoryCache().map(Function.identity());
                this.contentTypes = Collections.unmodifiableMap(new LinkedHashMap<String, MediaType>(builder.contentTypes()));
                this.pathMapper = builder.pathMapper();
                this.recordCacheCapacity = builder.recordCacheCapacity().map(Function.identity());
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public String context() {
                return this.context;
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            @Override
            public Optional<String> welcome() {
                return this.welcome;
            }

            @Override
            public Set<String> cachedFiles() {
                return this.cachedFiles;
            }

            @Override
            public Optional<MemoryCache> memoryCache() {
                return this.memoryCache;
            }

            @Override
            public Map<String, MediaType> contentTypes() {
                return this.contentTypes;
            }

            @Override
            public Function<String, String> pathMapper() {
                return this.pathMapper;
            }

            @Override
            public Optional<Integer> recordCacheCapacity() {
                return this.recordCacheCapacity;
            }

            public String toString() {
                return "BaseHandlerConfig{enabled=" + this.enabled + ",context=" + this.context + ",sockets=" + String.valueOf(this.sockets) + ",welcome=" + String.valueOf(this.welcome) + ",cachedFiles=" + String.valueOf(this.cachedFiles) + ",memoryCache=" + String.valueOf(this.memoryCache) + ",contentTypes=" + String.valueOf(this.contentTypes) + ",pathMapper=" + String.valueOf(this.pathMapper) + ",recordCacheCapacity=" + String.valueOf(this.recordCacheCapacity) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BaseHandlerConfig)) {
                    return false;
                }
                BaseHandlerConfig other = (BaseHandlerConfig)o;
                return this.enabled == other.enabled() && Objects.equals(this.context, other.context()) && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.welcome, other.welcome()) && Objects.equals(this.cachedFiles, other.cachedFiles()) && Objects.equals(this.memoryCache, other.memoryCache()) && Objects.equals(this.contentTypes, other.contentTypes()) && Objects.equals(this.pathMapper, other.pathMapper()) && Objects.equals(this.recordCacheCapacity, other.recordCacheCapacity());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.context, this.sockets, this.welcome, this.cachedFiles, this.memoryCache, this.contentTypes, this.pathMapper, this.recordCacheCapacity);
            }
        }
    }
}

