/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.media.type.MediaType;
import io.helidon.webserver.staticcontent.ClasspathHandlerConfig;
import io.helidon.webserver.staticcontent.FileSystemHandlerConfig;
import io.helidon.webserver.staticcontent.MemoryCache;
import io.helidon.webserver.staticcontent.MemoryCacheConfig;
import io.helidon.webserver.staticcontent.StaticContentConfigBlueprint;
import io.helidon.webserver.staticcontent.StaticContentConfigSupport;
import io.helidon.webserver.staticcontent.StaticContentFeature;
import io.helidon.webserver.staticcontent.TemporaryStorage;
import io.helidon.webserver.staticcontent.TemporaryStorageConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.staticcontent.StaticContentConfigBlueprint")
public interface StaticContentConfig
extends StaticContentConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StaticContentConfig instance) {
        return (Builder)StaticContentConfig.builder().from(instance);
    }

    public static StaticContentConfig create(Config config) {
        return ((Builder)StaticContentConfig.builder().config(config)).buildPrototype();
    }

    public static StaticContentConfig create() {
        return StaticContentConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, StaticContentConfig>
    implements io.helidon.common.Builder<Builder, StaticContentFeature> {
        private Builder() {
        }

        public StaticContentConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.StaticContentConfigImpl(this);
        }

        public StaticContentFeature build() {
            return StaticContentFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends StaticContentConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<ClasspathHandlerConfig> classpath = new ArrayList<ClasspathHandlerConfig>();
        private final List<FileSystemHandlerConfig> path = new ArrayList<FileSystemHandlerConfig>();
        private final Map<String, MediaType> contentTypes = new LinkedHashMap<String, MediaType>();
        private final Set<String> sockets = new LinkedHashSet<String>();
        private boolean enabled = true;
        private boolean isClasspathMutated;
        private boolean isPathMutated;
        private Config config;
        private double weight = 95.0;
        private MemoryCache memoryCache;
        private String name = "static-content";
        private String welcome;
        private TemporaryStorage temporaryStorage;

        protected BuilderBase() {
        }

        public BUILDER from(StaticContentConfig prototype) {
            this.enabled(prototype.enabled());
            this.weight(prototype.weight());
            this.name(prototype.name());
            this.memoryCache(prototype.memoryCache());
            this.temporaryStorage(prototype.temporaryStorage());
            if (!this.isClasspathMutated) {
                this.classpath.clear();
            }
            this.addClasspath(prototype.classpath());
            if (!this.isPathMutated) {
                this.path.clear();
            }
            this.addPath(prototype.path());
            this.addContentTypes(prototype.contentTypes());
            this.welcome(prototype.welcome());
            this.addSockets(prototype.sockets());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            this.weight(builder.weight());
            this.name(builder.name());
            builder.memoryCache().ifPresent(this::memoryCache);
            builder.temporaryStorage().ifPresent(this::temporaryStorage);
            if (this.isClasspathMutated) {
                if (builder.isClasspathMutated) {
                    this.addClasspath(builder.classpath);
                }
            } else {
                this.classpath.clear();
                this.addClasspath(builder.classpath);
            }
            if (this.isPathMutated) {
                if (builder.isPathMutated) {
                    this.addPath(builder.path);
                }
            } else {
                this.path.clear();
                this.addPath(builder.path);
            }
            this.addContentTypes(builder.contentTypes);
            builder.welcome().ifPresent(this::welcome);
            this.addSockets(builder.sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("memory-cache").map(MemoryCacheConfig::create).ifPresent(this::memoryCache);
            config.get("temporary-storage").map(TemporaryStorageConfig::create).ifPresent(this::temporaryStorage);
            config.get("classpath").mapList(ClasspathHandlerConfig::create).ifPresent(this::classpath);
            config.get("path").mapList(FileSystemHandlerConfig::create).ifPresent(this::path);
            config.get("content-types").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.contentTypes.put((String)node.get("name").asString().orElse((Object)node.name()), (MediaType)node.map(StaticContentConfigSupport.StaticContentMethods::createContentTypes).get())));
            config.get("welcome").as(String.class).ifPresent(this::welcome);
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMemoryCache() {
            this.memoryCache = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER memoryCache(MemoryCache memoryCache) {
            Objects.requireNonNull(memoryCache);
            this.memoryCache = memoryCache;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER memoryCache(MemoryCacheConfig memoryCacheConfig) {
            Objects.requireNonNull(memoryCacheConfig);
            this.memoryCache = MemoryCache.create(memoryCacheConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER memoryCache(Consumer<MemoryCacheConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            MemoryCacheConfig.Builder builder = MemoryCache.builder();
            consumer.accept(builder);
            this.memoryCache(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTemporaryStorage() {
            this.temporaryStorage = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temporaryStorage(TemporaryStorage temporaryStorage) {
            Objects.requireNonNull(temporaryStorage);
            this.temporaryStorage = temporaryStorage;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temporaryStorage(TemporaryStorageConfig temporaryStorageConfig) {
            Objects.requireNonNull(temporaryStorageConfig);
            this.temporaryStorage = TemporaryStorage.create(temporaryStorageConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temporaryStorage(Consumer<TemporaryStorageConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TemporaryStorageConfig.Builder builder = TemporaryStorage.builder();
            consumer.accept(builder);
            this.temporaryStorage(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER classpath(List<? extends ClasspathHandlerConfig> classpath) {
            Objects.requireNonNull(classpath);
            this.isClasspathMutated = true;
            this.classpath.clear();
            this.classpath.addAll(classpath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addClasspath(List<? extends ClasspathHandlerConfig> classpath) {
            Objects.requireNonNull(classpath);
            this.isClasspathMutated = true;
            this.classpath.addAll(classpath);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addClasspath(ClasspathHandlerConfig classpath) {
            Objects.requireNonNull(classpath);
            this.classpath.add(classpath);
            this.isClasspathMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addClasspath(Consumer<ClasspathHandlerConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ClasspathHandlerConfig.Builder builder = ClasspathHandlerConfig.builder();
            consumer.accept(builder);
            this.classpath.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER path(List<? extends FileSystemHandlerConfig> path) {
            Objects.requireNonNull(path);
            this.isPathMutated = true;
            this.path.clear();
            this.path.addAll(path);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPath(List<? extends FileSystemHandlerConfig> path) {
            Objects.requireNonNull(path);
            this.isPathMutated = true;
            this.path.addAll(path);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPath(FileSystemHandlerConfig path) {
            Objects.requireNonNull(path);
            this.path.add(path);
            this.isPathMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPath(Consumer<FileSystemHandlerConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            FileSystemHandlerConfig.Builder builder = FileSystemHandlerConfig.builder();
            consumer.accept(builder);
            this.path.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentTypes(Map<String, ? extends MediaType> contentTypes) {
            Objects.requireNonNull(contentTypes);
            this.contentTypes.clear();
            this.contentTypes.putAll(contentTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContentTypes(Map<String, ? extends MediaType> contentTypes) {
            Objects.requireNonNull(contentTypes);
            this.contentTypes.putAll(contentTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putContentType(String key, MediaType contentType) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(contentType);
            this.contentTypes.put(key, contentType);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearWelcome() {
            this.welcome = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER welcome(String welcome) {
            Objects.requireNonNull(welcome);
            this.welcome = welcome;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocket(String socket) {
            Objects.requireNonNull(socket);
            this.sockets.add(socket);
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public double weight() {
            return this.weight;
        }

        public String name() {
            return this.name;
        }

        public Optional<MemoryCache> memoryCache() {
            return Optional.ofNullable(this.memoryCache);
        }

        public Optional<TemporaryStorage> temporaryStorage() {
            return Optional.ofNullable(this.temporaryStorage);
        }

        public List<ClasspathHandlerConfig> classpath() {
            return this.classpath;
        }

        public List<FileSystemHandlerConfig> path() {
            return this.path;
        }

        public Map<String, MediaType> contentTypes() {
            return this.contentTypes;
        }

        public Optional<String> welcome() {
            return Optional.ofNullable(this.welcome);
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "StaticContentConfigBuilder{enabled=" + this.enabled + ",weight=" + this.weight + ",name=" + this.name + ",memoryCache=" + String.valueOf(this.memoryCache) + ",temporaryStorage=" + String.valueOf(this.temporaryStorage) + ",classpath=" + String.valueOf(this.classpath) + ",path=" + String.valueOf(this.path) + ",contentTypes=" + String.valueOf(this.contentTypes) + ",welcome=" + this.welcome + ",sockets=" + String.valueOf(this.sockets) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER memoryCache(Optional<? extends MemoryCache> memoryCache) {
            Objects.requireNonNull(memoryCache);
            this.memoryCache = memoryCache.map(MemoryCache.class::cast).orElse(this.memoryCache);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER temporaryStorage(Optional<? extends TemporaryStorage> temporaryStorage) {
            Objects.requireNonNull(temporaryStorage);
            this.temporaryStorage = temporaryStorage.map(TemporaryStorage.class::cast).orElse(this.temporaryStorage);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER welcome(Optional<String> welcome) {
            Objects.requireNonNull(welcome);
            this.welcome = welcome.map(String.class::cast).orElse(this.welcome);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class StaticContentConfigImpl
        implements StaticContentConfig,
        Supplier<StaticContentFeature> {
            private final boolean enabled;
            private final double weight;
            private final List<ClasspathHandlerConfig> classpath;
            private final List<FileSystemHandlerConfig> path;
            private final Map<String, MediaType> contentTypes;
            private final Optional<MemoryCache> memoryCache;
            private final Optional<TemporaryStorage> temporaryStorage;
            private final Optional<String> welcome;
            private final Set<String> sockets;
            private final String name;

            protected StaticContentConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.weight = builder.weight();
                this.name = builder.name();
                this.memoryCache = builder.memoryCache();
                this.temporaryStorage = builder.temporaryStorage();
                this.classpath = List.copyOf(builder.classpath());
                this.path = List.copyOf(builder.path());
                this.contentTypes = Collections.unmodifiableMap(new LinkedHashMap<String, MediaType>(builder.contentTypes()));
                this.welcome = builder.welcome();
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
            }

            public StaticContentFeature build() {
                return StaticContentFeature.create(this);
            }

            @Override
            public StaticContentFeature get() {
                return this.build();
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<MemoryCache> memoryCache() {
                return this.memoryCache;
            }

            @Override
            public Optional<TemporaryStorage> temporaryStorage() {
                return this.temporaryStorage;
            }

            @Override
            public List<ClasspathHandlerConfig> classpath() {
                return this.classpath;
            }

            @Override
            public List<FileSystemHandlerConfig> path() {
                return this.path;
            }

            @Override
            public Map<String, MediaType> contentTypes() {
                return this.contentTypes;
            }

            @Override
            public Optional<String> welcome() {
                return this.welcome;
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            public String toString() {
                return "StaticContentConfig{enabled=" + this.enabled + ",weight=" + this.weight + ",name=" + this.name + ",memoryCache=" + String.valueOf(this.memoryCache) + ",temporaryStorage=" + String.valueOf(this.temporaryStorage) + ",classpath=" + String.valueOf(this.classpath) + ",path=" + String.valueOf(this.path) + ",contentTypes=" + String.valueOf(this.contentTypes) + ",welcome=" + String.valueOf(this.welcome) + ",sockets=" + String.valueOf(this.sockets) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StaticContentConfig)) {
                    return false;
                }
                StaticContentConfig other = (StaticContentConfig)o;
                return this.enabled == other.enabled() && this.weight == other.weight() && Objects.equals(this.name, other.name()) && Objects.equals(this.memoryCache, other.memoryCache()) && Objects.equals(this.temporaryStorage, other.temporaryStorage()) && Objects.equals(this.classpath, other.classpath()) && Objects.equals(this.path, other.path()) && Objects.equals(this.contentTypes, other.contentTypes()) && Objects.equals(this.welcome, other.welcome()) && Objects.equals(this.sockets, other.sockets());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.weight, this.name, this.memoryCache, this.temporaryStorage, this.classpath, this.path, this.contentTypes, this.welcome, this.sockets);
            }
        }
    }
}

