/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.http.Http;
import io.helidon.webserver.Handler;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.staticcontent.StaticContentSupport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class StaticContentHandler
implements StaticContentSupport {
    private static final Logger LOGGER = Logger.getLogger(StaticContentHandler.class.getName());
    private final String welcomeFilename;
    private final Function<String, String> resolvePathFunction;
    private int webServerCounter = 0;

    StaticContentHandler(StaticContentSupport.Builder<?> builder) {
        this.welcomeFilename = builder.welcomeFileName();
        this.resolvePathFunction = builder.resolvePathFunction();
    }

    public void update(Routing.Rules routing) {
        routing.onNewWebServer(ws -> {
            this.webServerStarted();
            ws.whenShutdown().thenRun(this::webServerStopped);
        });
        routing.get(new Handler[]{(req, res) -> this.handle((Http.RequestMethod)Http.Method.GET, req, res)});
        routing.head(new Handler[]{(req, res) -> this.handle((Http.RequestMethod)Http.Method.HEAD, req, res)});
    }

    private synchronized void webServerStarted() {
        ++this.webServerCounter;
    }

    private synchronized void webServerStopped() {
        --this.webServerCounter;
        if (this.webServerCounter <= 0) {
            this.webServerCounter = 0;
            this.releaseCache();
        }
    }

    void releaseCache() {
    }

    void handle(Http.RequestMethod method, ServerRequest request, ServerResponse response) {
        if (method != Http.Method.GET && method != Http.Method.HEAD) {
            request.next();
            return;
        }
        String requestPath = request.path().toString();
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        requestPath = this.resolvePathFunction.apply(requestPath);
        try {
            if (!this.doHandle(method, requestPath, request, response)) {
                request.next();
            }
        }
        catch (HttpException httpException) {
            if (httpException.status().code() == Http.Status.NOT_FOUND_404.code()) {
                request.next();
            }
            throw httpException;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to access static resource", e);
            throw new HttpException("Cannot access static resource!", (Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500, (Throwable)e);
        }
    }

    abstract boolean doHandle(Http.RequestMethod var1, String var2, ServerRequest var3, ServerResponse var4) throws IOException, URISyntaxException;

    static void processEtag(String etag, RequestHeaders requestHeaders, ResponseHeaders responseHeaders) {
        if (etag == null || etag.isEmpty()) {
            return;
        }
        etag = StaticContentHandler.unquoteETag(etag);
        responseHeaders.put("ETag", new String[]{"\"" + etag + "\""});
        List ifNoneMatches = requestHeaders.values("If-None-Match");
        for (String ifNoneMatch : ifNoneMatches) {
            if (!"*".equals(ifNoneMatch = StaticContentHandler.unquoteETag(ifNoneMatch)) && !ifNoneMatch.equals(etag)) continue;
            throw new HttpException("Accepted by If-None-Match header!", (Http.ResponseStatus)Http.Status.NOT_MODIFIED_304);
        }
        List ifMatches = requestHeaders.values("If-Match");
        if (!ifMatches.isEmpty()) {
            boolean ifMatchChecked = false;
            for (String ifMatch : ifMatches) {
                if (!"*".equals(ifMatch = StaticContentHandler.unquoteETag(ifMatch)) && !ifMatch.equals(etag)) continue;
                ifMatchChecked = true;
                break;
            }
            if (!ifMatchChecked) {
                throw new HttpException("Not accepted by If-Match header!", (Http.ResponseStatus)Http.Status.PRECONDITION_FAILED_412);
            }
        }
    }

    private static String unquoteETag(String etag) {
        if (etag == null || etag.isEmpty()) {
            return etag;
        }
        if (etag.startsWith("W/") || etag.startsWith("w/")) {
            etag = etag.substring(2);
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    static void processModifyHeaders(Instant modified, RequestHeaders requestHeaders, ResponseHeaders responseHeaders) {
        if (modified == null) {
            return;
        }
        responseHeaders.lastModified(modified);
        Optional<Instant> ifModSince = requestHeaders.ifModifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifModSince.isPresent() && !ifModSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Modified-Since header!", (Http.ResponseStatus)Http.Status.NOT_MODIFIED_304);
        }
        Optional<Instant> ifUnmodSince = requestHeaders.ifUnmodifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifUnmodSince.isPresent() && ifUnmodSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Unmodified-Since header!", (Http.ResponseStatus)Http.Status.PRECONDITION_FAILED_412);
        }
    }

    static void throwNotFoundIf(boolean condition) {
        if (condition) {
            throw new HttpException("Content not found!", (Http.ResponseStatus)Http.Status.NOT_FOUND_404);
        }
    }

    static void redirect(ServerRequest request, ServerResponse response, String location) {
        String query = request.query();
        Object locationWithQuery = query == null ? location : location + "?" + query;
        response.status((Http.ResponseStatus)Http.Status.MOVED_PERMANENTLY_301);
        response.headers().put("Location", new String[]{locationWithQuery});
        response.send();
    }

    String welcomePageName() {
        return this.welcomeFilename;
    }
}

