/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.security.ClassToInstanceStore;
import io.helidon.webserver.security.SecurityConfigSupport;
import io.helidon.webserver.security.SecurityHandler;
import io.helidon.webserver.security.SecurityHandlerConfigBlueprint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.security.SecurityHandlerConfigBlueprint")
public interface SecurityHandlerConfig
extends SecurityHandlerConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SecurityHandlerConfig instance) {
        return (Builder)SecurityHandlerConfig.builder().from(instance);
    }

    public static SecurityHandlerConfig create(Config config) {
        return ((Builder)SecurityHandlerConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static SecurityHandlerConfig create(io.helidon.common.config.Config config) {
        return SecurityHandlerConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static SecurityHandlerConfig create() {
        return SecurityHandlerConfig.builder().buildPrototype();
    }

    @Override
    public Set<String> rolesAllowed();

    @Override
    public Optional<String> authenticator();

    @Override
    public Optional<String> authorizer();

    @Override
    public Optional<Boolean> authenticate();

    @Override
    public Optional<Boolean> authenticationOptional();

    @Override
    public Optional<Boolean> audit();

    @Override
    public Optional<Boolean> authorize();

    @Override
    public Optional<String> auditEventType();

    @Override
    public Optional<String> auditMessageFormat();

    @Override
    public List<SecurityHandler.QueryParamHandler> queryParams();

    @Override
    public Optional<ClassToInstanceStore<Object>> customObjects();

    @Override
    public List<String> sockets();

    @Override
    public Optional<io.helidon.common.config.Config> config();

    @Override
    public boolean combined();

    public static class Builder
    extends BuilderBase<Builder, SecurityHandlerConfig>
    implements io.helidon.common.Builder<Builder, SecurityHandler> {
        private Builder() {
        }

        public SecurityHandlerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SecurityHandlerConfigImpl(this);
        }

        public SecurityHandler build() {
            return SecurityHandler.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SecurityHandlerConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<SecurityHandler.QueryParamHandler> queryParams = new ArrayList<SecurityHandler.QueryParamHandler>();
        private final List<String> sockets = new ArrayList<String>();
        private final Set<String> rolesAllowed = new LinkedHashSet<String>();
        private Boolean audit;
        private Boolean authenticate;
        private Boolean authenticationOptional;
        private Boolean authorize;
        private boolean combined;
        private boolean isQueryParamsMutated;
        private boolean isSocketsMutated;
        private ClassToInstanceStore<Object> customObjects;
        private Config config;
        private String auditEventType;
        private String auditMessageFormat;
        private String authenticator;
        private String authorizer;

        protected BuilderBase() {
        }

        public BUILDER from(SecurityHandlerConfig prototype) {
            this.addRolesAllowed(prototype.rolesAllowed());
            this.authenticator(prototype.authenticator());
            this.authorizer(prototype.authorizer());
            this.authenticate(prototype.authenticate());
            this.authenticationOptional(prototype.authenticationOptional());
            this.audit(prototype.audit());
            this.authorize(prototype.authorize());
            this.auditEventType(prototype.auditEventType());
            this.auditMessageFormat(prototype.auditMessageFormat());
            if (!this.isQueryParamsMutated) {
                this.queryParams.clear();
            }
            this.addQueryParams(prototype.queryParams());
            this.customObjects(prototype.customObjects());
            if (!this.isSocketsMutated) {
                this.sockets.clear();
            }
            this.addSockets(prototype.sockets());
            this.config = prototype.config().map(Config::config).orElse(null);
            this.combined(prototype.combined());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addRolesAllowed(builder.rolesAllowed);
            builder.authenticator().ifPresent(this::authenticator);
            builder.authorizer().ifPresent(this::authorizer);
            builder.authenticate().ifPresent(this::authenticate);
            builder.authenticationOptional().ifPresent(this::authenticationOptional);
            builder.audit().ifPresent(this::audit);
            builder.authorize().ifPresent(this::authorize);
            builder.auditEventType().ifPresent(this::auditEventType);
            builder.auditMessageFormat().ifPresent(this::auditMessageFormat);
            if (this.isQueryParamsMutated) {
                if (builder.isQueryParamsMutated) {
                    this.addQueryParams(builder.queryParams);
                }
            } else {
                this.queryParams.clear();
                this.addQueryParams(builder.queryParams);
            }
            builder.customObjects().ifPresent(this::customObjects);
            if (this.isSocketsMutated) {
                if (builder.isSocketsMutated) {
                    this.addSockets(builder.sockets);
                }
            } else {
                this.sockets.clear();
                this.addSockets(builder.sockets);
            }
            builder.config().ifPresent(config -> this.config((io.helidon.common.config.Config)config));
            this.combined(builder.combined());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addObject(Object object) {
            SecurityConfigSupport.SecurityHandlerCustomMethods.addObject(this, object);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addObject(Class<?> objectType, Object object) {
            SecurityConfigSupport.SecurityHandlerCustomMethods.addObject(this, objectType, object);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("roles-allowed").asList(String.class).map(Set::copyOf).ifPresent(this::rolesAllowed);
            config.get("authenticator").as(String.class).ifPresent(this::authenticator);
            config.get("authorizer").as(String.class).ifPresent(this::authorizer);
            config.get("authenticate").as(Boolean.class).ifPresent(this::authenticate);
            config.get("authentication-optional").as(Boolean.class).ifPresent(this::authenticationOptional);
            config.get("audit").as(Boolean.class).ifPresent(this::audit);
            config.get("authorize").as(Boolean.class).ifPresent(this::authorize);
            config.get("audit-event-type").as(String.class).ifPresent(this::auditEventType);
            config.get("audit-message-format").as(String.class).ifPresent(this::auditMessageFormat);
            config.get("sockets").asList(String.class).ifPresent(this::sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rolesAllowed(Set<String> rolesAllowed) {
            Objects.requireNonNull(rolesAllowed);
            this.rolesAllowed.clear();
            this.rolesAllowed.addAll(rolesAllowed);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRolesAllowed(Set<String> rolesAllowed) {
            Objects.requireNonNull(rolesAllowed);
            this.rolesAllowed.addAll(rolesAllowed);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRoleAllowed(String roleAllowed) {
            Objects.requireNonNull(roleAllowed);
            this.rolesAllowed.add(roleAllowed);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAuthenticator() {
            this.authenticator = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER authenticator(String authenticator) {
            Objects.requireNonNull(authenticator);
            this.authenticator = authenticator;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAuthorizer() {
            this.authorizer = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER authorizer(String authorizer) {
            Objects.requireNonNull(authorizer);
            this.authorizer = authorizer;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAuthenticate() {
            this.authenticate = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER authenticate(boolean authenticate) {
            Objects.requireNonNull(authenticate);
            this.authenticate = authenticate;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAuthenticationOptional() {
            this.authenticationOptional = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER authenticationOptional(boolean authenticationOptional) {
            Objects.requireNonNull(authenticationOptional);
            this.authenticationOptional = authenticationOptional;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAudit() {
            this.audit = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER audit(boolean audit) {
            Objects.requireNonNull(audit);
            this.audit = audit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAuthorize() {
            this.authorize = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER authorize(boolean authorize) {
            Objects.requireNonNull(authorize);
            this.authorize = authorize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAuditEventType() {
            this.auditEventType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER auditEventType(String auditEventType) {
            Objects.requireNonNull(auditEventType);
            this.auditEventType = auditEventType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAuditMessageFormat() {
            this.auditMessageFormat = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER auditMessageFormat(String auditMessageFormat) {
            Objects.requireNonNull(auditMessageFormat);
            this.auditMessageFormat = auditMessageFormat;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queryParams(List<? extends SecurityHandler.QueryParamHandler> queryParams) {
            Objects.requireNonNull(queryParams);
            this.isQueryParamsMutated = true;
            this.queryParams.clear();
            this.queryParams.addAll(queryParams);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQueryParams(List<? extends SecurityHandler.QueryParamHandler> queryParams) {
            Objects.requireNonNull(queryParams);
            this.isQueryParamsMutated = true;
            this.queryParams.addAll(queryParams);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQueryParam(SecurityHandler.QueryParamHandler queryParam) {
            Objects.requireNonNull(queryParam);
            this.queryParams.add(queryParam);
            this.isQueryParamsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearCustomObjects() {
            this.customObjects = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER customObjects(ClassToInstanceStore<Object> customObjects) {
            Objects.requireNonNull(customObjects);
            this.customObjects = customObjects;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(List<String> sockets) {
            Objects.requireNonNull(sockets);
            this.isSocketsMutated = true;
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(List<String> sockets) {
            Objects.requireNonNull(sockets);
            this.isSocketsMutated = true;
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER combined(boolean combined) {
            this.combined = combined;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Set<String> rolesAllowed() {
            return this.rolesAllowed;
        }

        public Optional<String> authenticator() {
            return Optional.ofNullable(this.authenticator);
        }

        public Optional<String> authorizer() {
            return Optional.ofNullable(this.authorizer);
        }

        public Optional<Boolean> authenticate() {
            return Optional.ofNullable(this.authenticate);
        }

        public Optional<Boolean> authenticationOptional() {
            return Optional.ofNullable(this.authenticationOptional);
        }

        public Optional<Boolean> audit() {
            return Optional.ofNullable(this.audit);
        }

        public Optional<Boolean> authorize() {
            return Optional.ofNullable(this.authorize);
        }

        public Optional<String> auditEventType() {
            return Optional.ofNullable(this.auditEventType);
        }

        public Optional<String> auditMessageFormat() {
            return Optional.ofNullable(this.auditMessageFormat);
        }

        public List<SecurityHandler.QueryParamHandler> queryParams() {
            return this.queryParams;
        }

        public Optional<ClassToInstanceStore<Object>> customObjects() {
            return Optional.ofNullable(this.customObjects);
        }

        public List<String> sockets() {
            return this.sockets;
        }

        public boolean combined() {
            return this.combined;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "SecurityHandlerConfigBuilder{rolesAllowed=" + String.valueOf(this.rolesAllowed) + ",authenticator=" + this.authenticator + ",authorizer=" + this.authorizer + ",authenticate=" + this.authenticate + ",authenticationOptional=" + this.authenticationOptional + ",audit=" + this.audit + ",authorize=" + this.authorize + ",auditEventType=" + this.auditEventType + ",auditMessageFormat=" + this.auditMessageFormat + ",queryParams=" + String.valueOf(this.queryParams) + ",customObjects=" + String.valueOf(this.customObjects) + ",sockets=" + String.valueOf(this.sockets) + ",config=" + String.valueOf(this.config) + ",combined=" + this.combined + "}";
        }

        protected void preBuildPrototype() {
            new SecurityConfigSupport.SecurityHandlerDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER authenticator(Optional<String> authenticator) {
            Objects.requireNonNull(authenticator);
            this.authenticator = authenticator.map(String.class::cast).orElse(this.authenticator);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER authorizer(Optional<String> authorizer) {
            Objects.requireNonNull(authorizer);
            this.authorizer = authorizer.map(String.class::cast).orElse(this.authorizer);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER authenticate(Optional<Boolean> authenticate) {
            Objects.requireNonNull(authenticate);
            this.authenticate = authenticate.map(Boolean.class::cast).orElse(this.authenticate);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER authenticationOptional(Optional<Boolean> authenticationOptional) {
            Objects.requireNonNull(authenticationOptional);
            this.authenticationOptional = authenticationOptional.map(Boolean.class::cast).orElse(this.authenticationOptional);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER audit(Optional<Boolean> audit) {
            Objects.requireNonNull(audit);
            this.audit = audit.map(Boolean.class::cast).orElse(this.audit);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER authorize(Optional<Boolean> authorize) {
            Objects.requireNonNull(authorize);
            this.authorize = authorize.map(Boolean.class::cast).orElse(this.authorize);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER auditEventType(Optional<String> auditEventType) {
            Objects.requireNonNull(auditEventType);
            this.auditEventType = auditEventType.map(String.class::cast).orElse(this.auditEventType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER auditMessageFormat(Optional<String> auditMessageFormat) {
            Objects.requireNonNull(auditMessageFormat);
            this.auditMessageFormat = auditMessageFormat.map(String.class::cast).orElse(this.auditMessageFormat);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER customObjects(Optional<ClassToInstanceStore<Object>> customObjects) {
            Objects.requireNonNull(customObjects);
            this.customObjects = customObjects.map(ClassToInstanceStore.class::cast).orElse(this.customObjects);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class SecurityHandlerConfigImpl
        implements SecurityHandlerConfig,
        Supplier<SecurityHandler> {
            private final boolean combined;
            private final List<SecurityHandler.QueryParamHandler> queryParams;
            private final List<String> sockets;
            private final Optional<io.helidon.common.config.Config> config;
            private final Optional<ClassToInstanceStore<Object>> customObjects;
            private final Optional<Boolean> audit;
            private final Optional<Boolean> authenticate;
            private final Optional<Boolean> authenticationOptional;
            private final Optional<Boolean> authorize;
            private final Optional<String> auditEventType;
            private final Optional<String> auditMessageFormat;
            private final Optional<String> authenticator;
            private final Optional<String> authorizer;
            private final Set<String> rolesAllowed;

            protected SecurityHandlerConfigImpl(BuilderBase<?, ?> builder) {
                this.rolesAllowed = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.rolesAllowed()));
                this.authenticator = builder.authenticator().map(Function.identity());
                this.authorizer = builder.authorizer().map(Function.identity());
                this.authenticate = builder.authenticate().map(Function.identity());
                this.authenticationOptional = builder.authenticationOptional().map(Function.identity());
                this.audit = builder.audit().map(Function.identity());
                this.authorize = builder.authorize().map(Function.identity());
                this.auditEventType = builder.auditEventType().map(Function.identity());
                this.auditMessageFormat = builder.auditMessageFormat().map(Function.identity());
                this.queryParams = List.copyOf(builder.queryParams());
                this.customObjects = builder.customObjects().map(Function.identity());
                this.sockets = List.copyOf(builder.sockets());
                this.config = builder.config().map(Function.identity());
                this.combined = builder.combined();
            }

            public SecurityHandler build() {
                return SecurityHandler.create(this);
            }

            @Override
            public SecurityHandler get() {
                return this.build();
            }

            @Override
            public Set<String> rolesAllowed() {
                return this.rolesAllowed;
            }

            @Override
            public Optional<String> authenticator() {
                return this.authenticator;
            }

            @Override
            public Optional<String> authorizer() {
                return this.authorizer;
            }

            @Override
            public Optional<Boolean> authenticate() {
                return this.authenticate;
            }

            @Override
            public Optional<Boolean> authenticationOptional() {
                return this.authenticationOptional;
            }

            @Override
            public Optional<Boolean> audit() {
                return this.audit;
            }

            @Override
            public Optional<Boolean> authorize() {
                return this.authorize;
            }

            @Override
            public Optional<String> auditEventType() {
                return this.auditEventType;
            }

            @Override
            public Optional<String> auditMessageFormat() {
                return this.auditMessageFormat;
            }

            @Override
            public List<SecurityHandler.QueryParamHandler> queryParams() {
                return this.queryParams;
            }

            @Override
            public Optional<ClassToInstanceStore<Object>> customObjects() {
                return this.customObjects;
            }

            @Override
            public List<String> sockets() {
                return this.sockets;
            }

            @Override
            public Optional<io.helidon.common.config.Config> config() {
                return this.config;
            }

            @Override
            public boolean combined() {
                return this.combined;
            }

            public String toString() {
                return "SecurityHandlerConfig{rolesAllowed=" + String.valueOf(this.rolesAllowed) + ",authenticator=" + String.valueOf(this.authenticator) + ",authorizer=" + String.valueOf(this.authorizer) + ",authenticate=" + String.valueOf(this.authenticate) + ",authenticationOptional=" + String.valueOf(this.authenticationOptional) + ",audit=" + String.valueOf(this.audit) + ",authorize=" + String.valueOf(this.authorize) + ",auditEventType=" + String.valueOf(this.auditEventType) + ",auditMessageFormat=" + String.valueOf(this.auditMessageFormat) + ",queryParams=" + String.valueOf(this.queryParams) + ",customObjects=" + String.valueOf(this.customObjects) + ",sockets=" + String.valueOf(this.sockets) + ",config=" + String.valueOf(this.config) + ",combined=" + this.combined + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SecurityHandlerConfig)) {
                    return false;
                }
                SecurityHandlerConfig other = (SecurityHandlerConfig)o;
                return Objects.equals(this.rolesAllowed, other.rolesAllowed()) && Objects.equals(this.authenticator, other.authenticator()) && Objects.equals(this.authorizer, other.authorizer()) && Objects.equals(this.authenticate, other.authenticate()) && Objects.equals(this.authenticationOptional, other.authenticationOptional()) && Objects.equals(this.audit, other.audit()) && Objects.equals(this.authorize, other.authorize()) && Objects.equals(this.auditEventType, other.auditEventType()) && Objects.equals(this.auditMessageFormat, other.auditMessageFormat()) && Objects.equals(this.queryParams, other.queryParams()) && Objects.equals(this.customObjects, other.customObjects()) && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.config, other.config()) && this.combined == other.combined();
            }

            public int hashCode() {
                return Objects.hash(this.rolesAllowed, this.authenticator, this.authorizer, this.authenticate, this.authenticationOptional, this.audit, this.authorize, this.auditEventType, this.auditMessageFormat, this.queryParams, this.customObjects, this.sockets, this.config, this.combined);
            }
        }
    }
}

