/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.common.context.Context;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.tracing.Span;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.FilterChain;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.security.SecurityHandler;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

class SecurityContextFilter
implements Filter {
    private static final AtomicInteger SECURITY_COUNTER = new AtomicInteger();
    private final Security security;
    private final SecurityHandler defaultHandler;

    SecurityContextFilter(Security security, SecurityHandler defaultHandler) {
        this.security = security;
        this.defaultHandler = defaultHandler;
    }

    public void filter(FilterChain chain, RoutingRequest req, RoutingResponse res) {
        TreeMap allHeaders = new TreeMap(String::compareToIgnoreCase);
        allHeaders.putAll(req.headers().toMap());
        Context context = req.context();
        Optional newHeaders = context.get((Object)"security.addHeaders", Map.class);
        newHeaders.ifPresent(allHeaders::putAll);
        if (context.get(SecurityContext.class).isEmpty()) {
            SecurityEnvironment env = this.security.environmentBuilder().targetUri(req.requestedUri().toUri()).path(req.path().path()).method(req.prologue().method().text()).addAttribute("remotePeer", (Object)req.remotePeer()).addAttribute("userIp", (Object)req.remotePeer().host()).addAttribute("userPort", (Object)req.remotePeer().port()).transport(req.isSecure() ? "https" : "http").headers(allHeaders).queryParams(req.query()).build();
            EndpointConfig ec = EndpointConfig.builder().build();
            SecurityContext.Builder contextBuilder = this.security.contextBuilder(String.valueOf(SECURITY_COUNTER.incrementAndGet())).env(env).endpointConfig(ec);
            Span.current().ifPresent(it -> contextBuilder.tracingSpan(it.context()));
            SecurityContext securityContext = contextBuilder.build();
            context.register((Object)securityContext);
            context.register((Object)this.defaultHandler);
        }
        chain.proceed();
    }
}

