/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestImpl;
import io.helidon.webclient.WebClientServiceRequest;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

class NettyChannel {
    private final Channel channel;
    private CompletionStage<ChannelFuture> writeFuture = CompletableFuture.completedFuture(null);

    NettyChannel(Channel channel) {
        this.channel = channel;
    }

    void flush() {
        this.writeFuture = this.writeFuture.thenApply(f -> {
            if (this.channel.eventLoop().inEventLoop()) {
                this.channel.flush();
            } else {
                this.channel.eventLoop().execute(() -> ((Channel)this.channel).flush());
            }
            return f;
        });
    }

    void write(boolean flush, Object msg, Function<ChannelFuture, ChannelFuture> listeners) {
        this.writeFuture = this.writeFuture.thenCompose(f -> this.writeInt(flush, msg, listeners));
    }

    void write(boolean flush, Object msg) {
        this.writeFuture = this.writeFuture.thenCompose(f -> this.writeInt(flush, msg, Function.identity()));
    }

    private CompletionStage<ChannelFuture> writeInt(boolean flush, Object msg, Function<ChannelFuture, ChannelFuture> listeners) {
        CompletableFuture<ChannelFuture> channelFuture = new CompletableFuture<ChannelFuture>();
        if (this.channel.eventLoop().inEventLoop()) {
            if (flush) {
                channelFuture.complete(listeners.apply(this.channel.writeAndFlush(msg)));
            } else {
                channelFuture.complete(listeners.apply(this.channel.write(msg)));
            }
        } else if (flush) {
            this.channel.eventLoop().execute(() -> channelFuture.complete((ChannelFuture)listeners.apply(this.channel.writeAndFlush(msg))));
        } else {
            this.channel.eventLoop().execute(() -> channelFuture.complete((ChannelFuture)listeners.apply(this.channel.write(msg))));
        }
        return channelFuture;
    }

    WebClientServiceRequest serviceRequest() {
        return ((WebClientRequestImpl)this.channel.attr(WebClientRequestBuilderImpl.REQUEST).get()).configuration().clientServiceRequest();
    }

    boolean isConnectionReset() {
        return ((CompletableFuture)this.channel.attr(WebClientRequestBuilderImpl.RECEIVED).get()).isDone() || !this.channel.isActive();
    }

    public String toString() {
        return "NettyChannel{ctx=" + this.channel.toString() + "}";
    }
}

