/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.webclient.HelidonReadTimeoutHandler;
import io.helidon.webclient.NettyClientHandler;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

class NettyClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final RequestConfiguration configuration;

    NettyClientInitializer(RequestConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        URI address = this.configuration.requestURI();
        Duration readTimeout = this.configuration.readTimout();
        pipeline.addLast("readTimeout", (ChannelHandler)new HelidonReadTimeoutHandler(readTimeout.toMillis(), TimeUnit.MILLISECONDS));
        this.configuration.proxy().flatMap(proxy -> proxy.handler(address)).ifPresent(it -> {
            ProxyHandler proxyHandler = (ProxyHandler)it;
            proxyHandler.setConnectTimeoutMillis(this.configuration.connectTimeout().toMillis());
            pipeline.addLast(new ChannelHandler[]{proxyHandler});
        });
        if (address.toString().startsWith("https")) {
            this.configuration.sslContext().ifPresent(ctx -> {
                SslHandler sslHandler = ctx.newHandler(channel.alloc(), address.getHost(), address.getPort());
                if (!this.configuration.tls().disableHostnameVerification()) {
                    SSLEngine sslEngine = sslHandler.engine();
                    SSLParameters sslParameters = sslEngine.getSSLParameters();
                    sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                    sslEngine.setSSLParameters(sslParameters);
                }
                pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                sslHandler.handshakeFuture().addListener((GenericFutureListener)((FutureListener)channelFuture -> {
                    if (channelFuture.cause() != null) {
                        ((CompletableFuture)channel.attr(WebClientRequestBuilderImpl.RESULT).get()).completeExceptionally(channelFuture.cause());
                        channel.close();
                    }
                }));
            });
        }
        pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(ClientNettyLog.class, LogLevel.TRACE));
        pipeline.addLast("httpCodec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("httpDecompressor", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 50));
        pipeline.addLast("idleConnectionHandler", (ChannelHandler)new IdleConnectionHandler());
        pipeline.addLast("helidonHandler", (ChannelHandler)new NettyClientHandler());
    }

    private static final class ClientNettyLog {
        private ClientNettyLog() {
        }
    }

    private static class IdleConnectionHandler
    extends ChannelDuplexHandler {
        private static final Logger LOGGER = Logger.getLogger(IdleConnectionHandler.class.getName());

        private IdleConnectionHandler() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent && ctx.channel().hasAttr(WebClientRequestBuilderImpl.IN_USE) && ((AtomicBoolean)ctx.channel().attr(WebClientRequestBuilderImpl.IN_USE).get()).compareAndSet(false, true)) {
                ctx.close();
            }
            super.userEventTriggered(ctx, evt);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            if (ctx.channel().hasAttr(WebClientRequestBuilderImpl.CONNECTION_IDENT)) {
                WebClientRequestBuilderImpl.ConnectionIdent key = (WebClientRequestBuilderImpl.ConnectionIdent)channel.attr(WebClientRequestBuilderImpl.CONNECTION_IDENT).get();
                LOGGER.finest(() -> "Channel closed -> " + channel.hashCode());
                if (key != null) {
                    WebClientRequestBuilderImpl.removeChannelFromCache(key, channel);
                }
            }
            if (!((Boolean)channel.attr(WebClientRequestBuilderImpl.RESPONSE_RECEIVED).get()).booleanValue()) {
                CompletableFuture responseReceived = (CompletableFuture)channel.attr(WebClientRequestBuilderImpl.RECEIVED).get();
                CompletableFuture responseFuture = (CompletableFuture)channel.attr(WebClientRequestBuilderImpl.RESULT).get();
                WebClientException exception = new WebClientException("Connection reset by the host");
                responseReceived.completeExceptionally(exception);
                responseFuture.completeExceptionally(exception);
            }
            super.channelInactive(ctx);
        }
    }
}

