/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.webclient.NettyClientHandler;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientResponseHeaders;
import io.helidon.webclient.WebClientResponseHeadersImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.logging.Logger;

final class WebClientResponseImpl
implements WebClientResponse {
    private static final Logger LOGGER = Logger.getLogger(NettyClientHandler.class.getName());
    private final WebClientResponseHeadersImpl headers;
    private final Flow.Publisher<DataChunk> publisher;
    private final Http.ResponseStatus status;
    private final Http.Version version;
    private final MessageBodyReaderContext readerContext;
    private final NettyClientHandler.ResponseCloser responseCloser;
    private final URI lastEndpointUri;

    private WebClientResponseImpl(Builder builder) {
        this.headers = WebClientResponseHeadersImpl.create(builder.headers);
        this.publisher = builder.publisher;
        this.status = builder.status;
        this.version = builder.version;
        this.readerContext = builder.readerContext;
        this.responseCloser = builder.responseCloser;
        this.lastEndpointUri = builder.lastEndpointUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Http.ResponseStatus status() {
        return this.status;
    }

    @Override
    public Http.Version version() {
        return this.version;
    }

    @Override
    public URI lastEndpointURI() {
        return this.lastEndpointUri;
    }

    @Override
    public Single<Void> close() {
        return this.responseCloser.close();
    }

    @Override
    public MessageBodyReadableContent content() {
        Optional<MediaType> mediaType = this.headers.contentType();
        MessageBodyReaderContext readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)this.readerContext, null, (ReadOnlyParameters)this.headers, mediaType);
        return MessageBodyReadableContent.create(this.publisher, (MessageBodyReaderContext)readerContext);
    }

    @Override
    public WebClientResponseHeaders headers() {
        return this.headers;
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, WebClientResponseImpl> {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Flow.Publisher<DataChunk> publisher;
        private Http.ResponseStatus status = Http.Status.INTERNAL_SERVER_ERROR_500;
        private Http.Version version = Http.Version.V1_1;
        private NettyClientHandler.ResponseCloser responseCloser;
        private MessageBodyReaderContext readerContext;
        private URI lastEndpointUri;

        Builder() {
        }

        public WebClientResponseImpl build() {
            return new WebClientResponseImpl(this);
        }

        Builder contentPublisher(Flow.Publisher<DataChunk> publisher) {
            this.publisher = publisher;
            return this;
        }

        Builder readerContext(MessageBodyReaderContext readerContext) {
            this.readerContext = readerContext;
            return this;
        }

        Builder status(Http.ResponseStatus status) {
            this.status = status;
            return this;
        }

        Builder httpVersion(Http.Version version) {
            this.version = version;
            return this;
        }

        Builder addHeader(String name, List<String> values) {
            this.headers.put(name, values);
            return this;
        }

        Builder responseCloser(NettyClientHandler.ResponseCloser responseCloser) {
            this.responseCloser = responseCloser;
            return this;
        }

        Builder lastEndpointURI(URI lastEndpointUri) {
            this.lastEndpointUri = lastEndpointUri;
            return this;
        }
    }
}

