/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.webclient.WebClientRequestHeaders;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class WebClientRequestHeadersImpl
implements WebClientRequestHeaders {
    private static final DateTimeFormatter FORMATTER = Http.DateTime.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT"));
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    WebClientRequestHeadersImpl() {
    }

    WebClientRequestHeadersImpl(WebClientRequestHeaders headers) {
        this.headers.putAll(headers.toMap());
    }

    @Override
    public WebClientRequestHeaders unsetHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public WebClientRequestHeaders addCookie(String name, String value) {
        this.add("Cookie", ClientCookieEncoder.STRICT.encode((Cookie)new DefaultCookie(name, value)));
        return this;
    }

    @Override
    public WebClientRequestHeaders contentType(MediaType contentType) {
        this.put("Content-Type", contentType.toString());
        return this;
    }

    @Override
    public WebClientRequestHeaders contentLength(long length) {
        this.put("Content-Length", Long.toString(length));
        return this;
    }

    @Override
    public WebClientRequestHeaders addAccept(MediaType mediaType) {
        this.add("Accept", mediaType.toString());
        return this;
    }

    @Override
    public WebClientRequestHeaders ifModifiedSince(ZonedDateTime time) {
        this.put("If-Modified-Since", time.format(FORMATTER));
        return this;
    }

    @Override
    public WebClientRequestHeaders ifUnmodifiedSince(ZonedDateTime time) {
        this.put("If-Unmodified-Since", time.format(FORMATTER));
        return this;
    }

    @Override
    public WebClientRequestHeaders ifNoneMatch(String ... etags) {
        this.put("If-None-Match", this.processEtags(etags));
        return this;
    }

    @Override
    public WebClientRequestHeaders ifMatch(String ... etags) {
        this.put("If-Match", this.processEtags(etags));
        return this;
    }

    @Override
    public WebClientRequestHeaders ifRange(ZonedDateTime time) {
        this.put("If-Range", time.format(FORMATTER));
        return this;
    }

    @Override
    public WebClientRequestHeaders ifRange(String etag) {
        this.put("If-Range", this.processEtags(etag));
        return this;
    }

    @Override
    public List<MediaType> acceptedTypes() {
        ArrayList mediaTypes = new ArrayList();
        this.headers.computeIfAbsent("Accept", (? super K k) -> new ArrayList()).forEach(s -> mediaTypes.add(MediaType.parse((String)s)));
        return Collections.unmodifiableList(mediaTypes);
    }

    @Override
    public MediaType contentType() {
        List contentType = this.headers.computeIfAbsent("Content-Type", (? super K k) -> new ArrayList());
        return contentType.size() == 0 ? MediaType.WILDCARD : MediaType.parse((String)((String)contentType.get(0)));
    }

    @Override
    public Optional<Long> contentLength() {
        return Optional.ofNullable(this.headers.get("Content-Length")).map(list -> Long.parseLong((String)list.get(0)));
    }

    @Override
    public Optional<ZonedDateTime> ifModifiedSince() {
        return this.parseToDate("If-Modified-Since");
    }

    @Override
    public Optional<ZonedDateTime> ifUnmodifiedSince() {
        return this.parseToDate("If-Unmodified-Since");
    }

    @Override
    public List<String> ifNoneMatch() {
        return this.all("If-None-Match").stream().map(this::unquoteETag).collect(Collectors.toList());
    }

    @Override
    public List<String> ifMatch() {
        return this.all("If-Match").stream().map(this::unquoteETag).collect(Collectors.toList());
    }

    @Override
    public Optional<ZonedDateTime> ifRangeDate() {
        return this.parseToDate("If-Range");
    }

    @Override
    public Optional<String> ifRangeString() {
        return this.first("If-Range").map(this::unquoteETag);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    public Optional<String> first(String name) {
        return Optional.ofNullable(this.headers.get(name)).map(list -> (String)list.get(0));
    }

    public List<String> all(String headerName) {
        return Collections.unmodifiableList(this.headers.getOrDefault(headerName, new ArrayList()));
    }

    public List<String> put(String key, String ... values) {
        ArrayList list = this.headers.put(key, Arrays.asList(values));
        return Collections.unmodifiableList(list == null ? new ArrayList() : list);
    }

    public List<String> put(String key, Iterable<String> values) {
        ArrayList list = this.headers.put(key, this.iterableToList(values));
        return Collections.unmodifiableList(list == null ? new ArrayList() : list);
    }

    public List<String> putIfAbsent(String key, String ... values) {
        ArrayList list = this.headers.putIfAbsent(key, Arrays.asList(values));
        return Collections.unmodifiableList(list == null ? new ArrayList() : list);
    }

    public List<String> putIfAbsent(String key, Iterable<String> values) {
        ArrayList list = this.headers.putIfAbsent(key, this.iterableToList(values));
        return Collections.unmodifiableList(list == null ? new ArrayList() : list);
    }

    public List<String> computeIfAbsent(String key, Function<String, Iterable<String>> values) {
        List<String> associatedHeaders = this.headers.get(key);
        if (associatedHeaders == null) {
            return this.put(key, values.apply(key));
        }
        return Collections.unmodifiableList(associatedHeaders);
    }

    public List<String> computeSingleIfAbsent(String key, Function<String, String> value) {
        List<String> associatedHeaders = this.headers.get(key);
        if (associatedHeaders == null) {
            return this.put(key, value.apply(key));
        }
        return Collections.unmodifiableList(associatedHeaders);
    }

    @Override
    public WebClientRequestHeaders putAll(Parameters parameters) {
        this.headers.putAll(parameters.toMap());
        return this;
    }

    @Override
    public WebClientRequestHeaders add(String key, String ... values) {
        this.headers.computeIfAbsent(key, (? super K k) -> new ArrayList()).addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public WebClientRequestHeaders add(String key, Iterable<String> values) {
        this.headers.computeIfAbsent(key, (? super K k) -> new ArrayList()).addAll(this.iterableToList(values));
        return this;
    }

    @Override
    public WebClientRequestHeaders addAll(Parameters parameters) {
        parameters.toMap().forEach(this::add);
        return this;
    }

    public List<String> remove(String key) {
        ArrayList value = this.headers.remove(key);
        return value == null ? new ArrayList() : value;
    }

    public Map<String, List<String>> toMap() {
        return Collections.unmodifiableMap(new HashMap<String, List<String>>(this.headers));
    }

    private List<String> iterableToList(Iterable<String> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    private Optional<ZonedDateTime> parseToDate(String header) {
        return this.first(header).map(Http.DateTime::parse);
    }

    private Iterable<String> processEtags(String ... etags) {
        HashSet<String> set = new HashSet<String>();
        if (etags.length > 0) {
            if (etags.length == 1 && etags[0].equals("*")) {
                set.add(etags[0]);
            } else {
                for (String etag : etags) {
                    set.add("\"" + etag + "\"");
                }
            }
        }
        return set;
    }

    private String unquoteETag(String etag) {
        if (etag == null || etag.isEmpty()) {
            return etag;
        }
        if (etag.startsWith("W/") || etag.startsWith("w/")) {
            etag = etag.substring(2);
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }
}

