/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.GenericType;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.context.spi.DataPropagationProvider;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.reactive.Single;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webclient.DnsResolverType;
import io.helidon.webclient.NettyClient;
import io.helidon.webclient.NettyClientInitializer;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.RequestContentSubscriber;
import io.helidon.webclient.UriComponentEncoder;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientQueryParams;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientRequestHeadersImpl;
import io.helidon.webclient.WebClientRequestImpl;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.WebClientServiceRequestImpl;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.WebClientTls;
import io.helidon.webclient.spi.WebClientService;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

class WebClientRequestBuilderImpl
implements WebClientRequestBuilder {
    private static final Logger LOGGER = Logger.getLogger(WebClientRequestBuilderImpl.class.getName());
    private static final Map<ConnectionIdent, Set<ChannelRecord>> CHANNEL_CACHE = new ConcurrentHashMap<ConnectionIdent, Set<ChannelRecord>>();
    private static final List<DataPropagationProvider> PROPAGATION_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(DataPropagationProvider.class)).build().asList();
    static final AttributeKey<WebClientRequestImpl> REQUEST = AttributeKey.valueOf((String)"request");
    static final AttributeKey<CompletableFuture<WebClientServiceResponse>> RECEIVED = AttributeKey.valueOf((String)"received");
    static final AttributeKey<CompletableFuture<WebClientServiceResponse>> COMPLETED = AttributeKey.valueOf((String)"completed");
    static final AttributeKey<CompletableFuture<WebClientResponse>> RESULT = AttributeKey.valueOf((String)"result");
    static final AttributeKey<AtomicBoolean> IN_USE = AttributeKey.valueOf((String)"inUse");
    static final AttributeKey<AtomicBoolean> RETURN = AttributeKey.valueOf((String)"finished");
    static final AttributeKey<Boolean> RESPONSE_RECEIVED = AttributeKey.valueOf((String)"responseReceived");
    static final AttributeKey<WebClientResponse> RESPONSE = AttributeKey.valueOf((String)"response");
    static final AttributeKey<ConnectionIdent> CONNECTION_IDENT = AttributeKey.valueOf((String)"connectionIdent");
    static final AttributeKey<Long> REQUEST_ID = AttributeKey.valueOf((String)"requestID");
    static final AttributeKey<Boolean> WILL_CLOSE = AttributeKey.valueOf((String)"willClose");
    private static final AtomicLong REQUEST_NUMBER = new AtomicLong(0L);
    private static final String DEFAULT_TRANSPORT_PROTOCOL = "http";
    private static final Map<String, Integer> DEFAULT_SUPPORTED_PROTOCOLS = new HashMap<String, Integer>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final NioEventLoopGroup eventGroup;
    private final WebClientConfiguration configuration;
    private final Http.RequestMethod method;
    private final WebClientRequestHeaders headers;
    private final WebClientQueryParams queryParams;
    private final MessageBodyReaderContext readerContext;
    private final MessageBodyWriterContext writerContext;
    private URI uri;
    private URI finalUri;
    private Http.Version httpVersion;
    private Context context;
    private Proxy proxy;
    private String fragment;
    private boolean followRedirects;
    private boolean skipUriEncoding;
    private int redirectionCount;
    private RequestConfiguration requestConfiguration;
    private HttpRequest.Path path;
    private List<WebClientService> services;
    private Duration readTimeout;
    private Duration connectTimeout;
    private boolean keepAlive;
    private Long requestId;
    private boolean allowChunkedEncoding;
    private DnsResolverType dnsResolverType;

    private WebClientRequestBuilderImpl(NioEventLoopGroup eventGroup, WebClientConfiguration configuration, Http.RequestMethod method) {
        this.eventGroup = eventGroup;
        this.configuration = configuration;
        this.method = method;
        this.uri = configuration.uri();
        this.skipUriEncoding = false;
        this.allowChunkedEncoding = true;
        this.path = ClientPath.create(null, "", new HashMap<String, String>());
        this.headers = new WebClientRequestHeadersImpl(this.configuration.headers());
        this.queryParams = new WebClientQueryParams();
        this.httpVersion = Http.Version.V1_1;
        this.redirectionCount = 0;
        this.services = configuration.clientServices();
        this.readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)configuration.readerContext());
        this.writerContext = MessageBodyWriterContext.create((MessageBodyWriterContext)configuration.writerContext(), (Parameters)this.headers);
        this.requestId = null;
        Context.Builder contextBuilder = Context.builder().id("webclient-" + this.requestId);
        configuration.context().ifPresentOrElse(arg_0 -> ((Context.Builder)contextBuilder).parent(arg_0), () -> Contexts.context().ifPresent(arg_0 -> ((Context.Builder)contextBuilder).parent(arg_0)));
        this.context = contextBuilder.build();
        this.followRedirects = configuration.followRedirects();
        this.readTimeout = configuration.readTimout();
        this.connectTimeout = configuration.connectTimeout();
        this.proxy = configuration.proxy().orElse(Proxy.noProxy());
        this.keepAlive = configuration.keepAlive();
        this.dnsResolverType = configuration.dnsResolverType();
    }

    static WebClientRequestBuilder create(NioEventLoopGroup eventGroup, WebClientConfiguration configuration, Http.RequestMethod method) {
        return new WebClientRequestBuilderImpl(eventGroup, configuration, method);
    }

    static WebClientRequestBuilder create(WebClientRequestImpl clientRequest) {
        WebClientRequestBuilderImpl builder = new WebClientRequestBuilderImpl(NettyClient.eventGroup(), clientRequest.configuration(), (Http.RequestMethod)Http.Method.GET);
        builder.httpVersion = clientRequest.version();
        builder.proxy = clientRequest.proxy();
        builder.redirectionCount = clientRequest.redirectionCount() + 1;
        int maxRedirects = builder.configuration.maxRedirects();
        if (builder.redirectionCount > maxRedirects) {
            throw new WebClientException("Max number of redirects extended! (" + maxRedirects + ")");
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChannelFuture obtainChannelFuture(RequestConfiguration configuration, Bootstrap bootstrap) {
        Set channels;
        ConnectionIdent connectionIdent = new ConnectionIdent(configuration);
        Set set = channels = CHANNEL_CACHE.computeIfAbsent(connectionIdent, s -> Collections.synchronizedSet(new HashSet()));
        synchronized (set) {
            Channel channel;
            for (ChannelRecord channelRecord : channels) {
                channel = channelRecord.channel;
                if (channel.isOpen() && ((AtomicBoolean)channel.attr(IN_USE).get()).compareAndSet(false, true)) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(() -> "Reusing -> " + channel.hashCode() + ", settting in use -> true");
                    }
                    return channelRecord.channelFuture;
                }
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.finest(() -> "Not accepted -> " + channel.hashCode() + ", open -> " + channel.isOpen() + ", in use -> " + channel.attr(IN_USE).get());
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(() -> "New connection to -> " + connectionIdent);
            }
            URI uri = connectionIdent.base;
            ChannelFuture connect = bootstrap.connect(uri.getHost(), uri.getPort());
            channel = connect.channel();
            channel.attr(IN_USE).set((Object)new AtomicBoolean(true));
            channel.attr(RETURN).set((Object)new AtomicBoolean(false));
            channel.attr(CONNECTION_IDENT).set((Object)connectionIdent);
            channels.add(new ChannelRecord(connect));
            return connect;
        }
    }

    static void removeChannelFromCache(ConnectionIdent key, Channel channel) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(() -> "Removing from channel cache. Connection ident ->  " + key + ", channel -> " + channel.hashCode());
        }
        CHANNEL_CACHE.get(key).remove(new ChannelRecord(channel));
    }

    @Override
    public WebClientRequestBuilder uri(String uri) {
        return this.uri(URI.create(uri));
    }

    @Override
    public WebClientRequestBuilder uri(URL url) {
        try {
            return this.uri(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new WebClientException("Failed to create URI from URL", e);
        }
    }

    @Override
    public WebClientRequestBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public WebClientRequestBuilder skipUriEncoding() {
        this.skipUriEncoding = true;
        this.queryParams.skipEncoding();
        return this;
    }

    @Override
    public WebClientRequestBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public WebClientRequestBuilder property(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    @Override
    public WebClientRequestBuilder context(Context context) {
        this.context = context;
        return this;
    }

    @Override
    public WebClientRequestHeaders headers() {
        return this.headers;
    }

    @Override
    public WebClientRequestBuilder queryParam(String name, String ... values) {
        this.queryParams.add(name, values);
        return this;
    }

    @Override
    public WebClientRequestBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public WebClientRequestBuilder headers(Headers headers) {
        this.headers.clear();
        this.headers.putAll((Parameters)headers);
        return this;
    }

    @Override
    public WebClientRequestBuilder headers(Function<WebClientRequestHeaders, Headers> headers) {
        Headers newHeaders = headers.apply(this.headers);
        if (!newHeaders.equals(this.headers)) {
            this.headers(newHeaders);
        }
        return this;
    }

    @Override
    public WebClientRequestBuilder queryParams(Parameters queryParams) {
        Objects.requireNonNull(queryParams);
        queryParams.toMap().forEach((name, params) -> this.queryParam((String)name, params.toArray(new String[0])));
        return this;
    }

    @Override
    public WebClientRequestBuilder httpVersion(Http.Version httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    @Override
    public WebClientRequestBuilder connectTimeout(long amount, TimeUnit unit) {
        this.connectTimeout = Duration.of(amount, unit.toChronoUnit());
        return this;
    }

    @Override
    public WebClientRequestBuilder readTimeout(long amount, TimeUnit unit) {
        this.readTimeout = Duration.of(amount, unit.toChronoUnit());
        return this;
    }

    @Override
    public WebClientRequestBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    @Override
    public WebClientRequestBuilder path(HttpRequest.Path path) {
        this.path = path;
        return this;
    }

    @Override
    public WebClientRequestBuilder path(String path) {
        this.path = ClientPath.create(null, path, new HashMap<String, String>());
        return this;
    }

    @Override
    public WebClientRequestBuilder contentType(MediaType contentType) {
        this.headers.contentType(contentType);
        this.writerContext.contentType(contentType);
        return this;
    }

    @Override
    public WebClientRequestBuilder accept(MediaType ... mediaTypes) {
        Arrays.stream(mediaTypes).forEach(this.headers::addAccept);
        return this;
    }

    @Override
    public WebClientRequestBuilder keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public WebClientRequestBuilder requestId(long requestId) {
        this.requestId = requestId;
        return this;
    }

    @Override
    public WebClientRequestBuilder allowChunkedEncoding(boolean allowChunkedEncoding) {
        this.allowChunkedEncoding = allowChunkedEncoding;
        return this;
    }

    @Override
    public <T> Single<T> request(Class<T> responseType) {
        return this.request(GenericType.create(responseType));
    }

    @Override
    public <T> Single<T> request(GenericType<T> responseType) {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invokeWithEntity((Flow.Publisher<DataChunk>)Single.empty(), responseType));
    }

    @Override
    public Single<WebClientResponse> request() {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invoke((Flow.Publisher<DataChunk>)Single.empty()));
    }

    @Override
    public Single<WebClientResponse> submit() {
        return this.request();
    }

    @Override
    public <T> Single<T> submit(Flow.Publisher<DataChunk> requestEntity, Class<T> responseType) {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invokeWithEntity(requestEntity, GenericType.create((Class)responseType)));
    }

    @Override
    public <T> Single<T> submit(Object requestEntity, Class<T> responseType) {
        GenericType responseGenericType = GenericType.create(responseType);
        Flow.Publisher dataChunkPublisher = this.writerContext.marshall(Single.just((Object)requestEntity), GenericType.create((Object)requestEntity));
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invokeWithEntity(dataChunkPublisher, responseGenericType));
    }

    @Override
    public Single<WebClientResponse> submit(Flow.Publisher<DataChunk> requestEntity) {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invoke(requestEntity));
    }

    @Override
    public Single<WebClientResponse> submit(Object requestEntity) {
        Flow.Publisher dataChunkPublisher = this.writerContext.marshall(Single.just((Object)requestEntity), GenericType.create((Object)requestEntity));
        return this.submit(dataChunkPublisher);
    }

    @Override
    public Single<WebClientResponse> submit(Function<MessageBodyWriterContext, Flow.Publisher<DataChunk>> function) {
        return this.submit(function.apply(this.writerContext));
    }

    @Override
    public MessageBodyReaderContext readerContext() {
        return this.readerContext;
    }

    @Override
    public MessageBodyWriterContext writerContext() {
        return this.writerContext;
    }

    long requestId() {
        return this.requestId;
    }

    Http.RequestMethod method() {
        return this.method;
    }

    Http.Version httpVersion() {
        return this.httpVersion;
    }

    URI uri() {
        return this.finalUri;
    }

    Parameters queryParams() {
        return this.queryParams;
    }

    String query() {
        return this.finalUri.getRawQuery() == null ? "" : this.finalUri.getRawQuery();
    }

    String queryFromParams() {
        StringBuilder queries = new StringBuilder();
        for (Map.Entry entry : this.queryParams.pickCorrectParameters().toMap().entrySet()) {
            for (String value : (List)entry.getValue()) {
                if (queries.length() > 0) {
                    queries.append("&");
                }
                if (((String)entry.getKey()).isEmpty()) {
                    queries.append(value);
                    continue;
                }
                queries.append((String)entry.getKey()).append("=").append(value);
            }
        }
        return queries.toString();
    }

    String fragment() {
        return this.fragment;
    }

    HttpRequest.Path path() {
        return this.path;
    }

    RequestConfiguration requestConfiguration() {
        return this.requestConfiguration;
    }

    Map<String, String> properties() {
        return this.properties;
    }

    Proxy proxy() {
        return this.proxy;
    }

    int redirectionCount() {
        return this.redirectionCount;
    }

    Context context() {
        return this.context;
    }

    private <T> Single<T> invokeWithEntity(Flow.Publisher<DataChunk> requestEntity, GenericType<T> responseType) {
        return this.invoke(requestEntity).map(this::getContentFromClientResponse).flatMapSingle(content -> content.as(responseType));
    }

    private Single<WebClientResponse> invoke(Flow.Publisher<DataChunk> requestEntity) {
        this.finalUri = this.prepareFinalURI();
        if (this.requestId == null) {
            this.requestId = REQUEST_NUMBER.incrementAndGet();
        }
        CompletableFuture<WebClientServiceRequest> sent = new CompletableFuture<WebClientServiceRequest>();
        CompletableFuture<WebClientServiceResponse> responseReceived = new CompletableFuture<WebClientServiceResponse>();
        CompletableFuture<WebClientServiceResponse> complete = new CompletableFuture<WebClientServiceResponse>();
        WebClientServiceRequestImpl completedRequest = new WebClientServiceRequestImpl(this, sent, responseReceived, complete);
        CompletionStage<WebClientServiceRequest> rcs = CompletableFuture.completedFuture(completedRequest);
        for (WebClientService service : this.services) {
            rcs = rcs.thenCompose(service::request).thenApply(servReq -> {
                this.finalUri = this.recreateURI((WebClientServiceRequest)servReq);
                return servReq;
            });
        }
        Single single = Single.create(rcs.thenCompose(serviceRequest -> {
            URI requestUri = WebClientRequestBuilderImpl.relativizeNoProxy(this.finalUri, this.proxy, this.configuration.relativeUris());
            this.requestId = serviceRequest.requestId();
            HttpHeaders headers = this.toNettyHttpHeaders();
            DefaultHttpRequest request = new DefaultHttpRequest(this.toNettyHttpVersion(this.httpVersion), this.toNettyMethod(this.method), requestUri.toASCIIString(), headers);
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            this.requestConfiguration = ((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)RequestConfiguration.builder(this.finalUri).update(this.configuration)).followRedirects(this.followRedirects)).clientServiceRequest((WebClientServiceRequest)serviceRequest).readerContext(this.readerContext)).writerContext(this.writerContext)).connectTimeout(this.connectTimeout)).readTimeout(this.readTimeout)).services(this.services).context(this.context)).proxy(this.proxy)).keepAlive(keepAlive)).requestId(this.requestId).build();
            WebClientRequestImpl clientRequest = new WebClientRequestImpl(this);
            CompletableFuture result = new CompletableFuture();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)this.eventGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new NettyClientInitializer(this.requestConfiguration))).option(ChannelOption.SO_KEEPALIVE, (Object)keepAlive)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.connectTimeout.toMillis()));
            switch (this.dnsResolverType) {
                case ROUND_ROBIN: {
                    bootstrap.resolver((AddressResolverGroup)new RoundRobinDnsAddressResolverGroup(NioDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
                    break;
                }
                case NONE: {
                    bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
                    break;
                }
            }
            ChannelFuture channelFuture = keepAlive ? WebClientRequestBuilderImpl.obtainChannelFuture(this.requestConfiguration, bootstrap) : bootstrap.connect(this.finalUri.getHost(), this.finalUri.getPort());
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(() -> "(client reqID: " + this.requestId + ") Channel hashcode -> " + channelFuture.channel().hashCode());
                }
                channelFuture.channel().attr(REQUEST).set((Object)clientRequest);
                channelFuture.channel().attr(RESPONSE_RECEIVED).set((Object)false);
                channelFuture.channel().attr(RECEIVED).set((Object)responseReceived);
                channelFuture.channel().attr(COMPLETED).set((Object)complete);
                channelFuture.channel().attr(WILL_CLOSE).set((Object)(!keepAlive ? 1 : 0));
                channelFuture.channel().attr(RESULT).set((Object)result);
                channelFuture.channel().attr(REQUEST_ID).set((Object)this.requestId);
                Throwable cause = future.cause();
                if (null == cause) {
                    RequestContentSubscriber requestContentSubscriber = new RequestContentSubscriber(request, channelFuture.channel(), result, sent, this.allowChunkedEncoding);
                    requestEntity.subscribe(requestContentSubscriber);
                } else {
                    sent.completeExceptionally(cause);
                    responseReceived.completeExceptionally(cause);
                    complete.completeExceptionally(cause);
                    result.completeExceptionally(new WebClientException(this.finalUri.toString(), cause));
                }
            }));
            return result;
        }));
        return this.wrapWithContext(single);
    }

    private void runInContext(Map<Class<?>, Object> data, Runnable command) {
        PROPAGATION_PROVIDERS.forEach(provider -> provider.propagateData(data.get(provider.getClass())));
        Contexts.runInContext((Context)this.context, (Runnable)command);
    }

    private <T> Single<T> wrapWithContext(Single<T> single) {
        final HashMap contextProperties = new HashMap();
        PROPAGATION_PROVIDERS.forEach(provider -> contextProperties.put(provider.getClass(), provider.data()));
        return Single.create((Flow.Subscriber<? super T> subscriber) -> single.subscribe(new Flow.Subscriber<T>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                WebClientRequestBuilderImpl.this.runInContext(contextProperties, () -> subscriber.onSubscribe(subscription));
            }

            @Override
            public void onNext(T item) {
                WebClientRequestBuilderImpl.this.runInContext(contextProperties, () -> subscriber.onNext(item));
            }

            @Override
            public void onError(Throwable throwable) {
                WebClientRequestBuilderImpl.this.runInContext(contextProperties, () -> subscriber.onError(throwable));
            }

            @Override
            public void onComplete() {
                WebClientRequestBuilderImpl.this.runInContext(contextProperties, subscriber::onComplete);
            }
        }));
    }

    private MessageBodyReadableContent getContentFromClientResponse(WebClientResponse response) {
        if (response.status().code() >= Http.Status.MOVED_PERMANENTLY_301.code()) {
            throw new WebClientException("Request failed with code " + response.status().code());
        }
        return response.content();
    }

    private URI recreateURI(WebClientServiceRequest request) {
        this.clearUri(request.schema(), request.host(), request.port());
        return this.prepareFinalURI();
    }

    private URI prepareFinalURI() {
        int port;
        if (this.uri == null) {
            throw new WebClientException("There is no specified uri for the request.");
        }
        if (this.uri.getHost() == null) {
            throw new WebClientException("Invalid uri " + this.uri + ". Uri.getHost() returned null.");
        }
        String scheme = Optional.ofNullable(this.uri.getScheme()).orElseThrow(() -> new WebClientException("Transport protocol has be to be specified in uri: " + this.uri.toString()));
        if (!DEFAULT_SUPPORTED_PROTOCOLS.containsKey(scheme)) {
            throw new WebClientException(scheme + " transport protocol is not supported!");
        }
        int n = port = this.uri.getPort() > -1 ? this.uri.getPort() : DEFAULT_SUPPORTED_PROTOCOLS.getOrDefault(scheme, -1).intValue();
        if (port == -1) {
            throw new WebClientException("Client could not get port for schema " + scheme + ". Please specify correct port to use.");
        }
        String path = this.resolvePath();
        this.path = ClientPath.create(null, path, new HashMap<String, String>());
        String query = this.resolveQuery();
        String fragment = this.resolveFragment();
        StringBuilder sb = new StringBuilder();
        sb.append(scheme).append("://").append(this.uri.getHost()).append(":").append(port);
        WebClientRequestBuilderImpl.constructRelativeURI(sb, path, query, fragment);
        this.clearUri(scheme, this.uri.getHost(), port);
        return URI.create(sb.toString());
    }

    private void clearUri(String scheme, String host, int port) {
        try {
            this.uri = new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new WebClientException("Could not create URI!", e);
        }
    }

    private String resolveFragment() {
        if (this.fragment == null) {
            this.fragment(this.uri.getRawFragment());
        }
        if (this.skipUriEncoding || this.fragment == null) {
            return this.fragment;
        }
        return UriComponentEncoder.encode(this.fragment, UriComponentEncoder.Type.FRAGMENT);
    }

    static URI relativizeNoProxy(URI finalUri, Proxy proxy, boolean relativeUris) {
        if (proxy == Proxy.noProxy() || proxy.noProxyPredicate().apply(finalUri).booleanValue() || relativeUris) {
            String path = finalUri.getRawPath();
            String fragment = finalUri.getRawFragment();
            String query = finalUri.getRawQuery();
            StringBuilder sb = new StringBuilder();
            WebClientRequestBuilderImpl.constructRelativeURI(sb, path, query, fragment);
            return URI.create(sb.toString());
        }
        return finalUri;
    }

    private static void constructRelativeURI(StringBuilder stringBuilder, String path, String query, String fragment) {
        if (path != null) {
            stringBuilder.append(path);
        }
        if (query != null) {
            stringBuilder.append('?').append(query);
        }
        if (fragment != null) {
            stringBuilder.append('#').append(fragment);
        }
    }

    private String resolveQuery() {
        Object queries = this.queryFromParams();
        String uriQuery = this.uri.getRawQuery();
        if (((String)queries).isEmpty()) {
            queries = uriQuery;
        } else if (uriQuery != null) {
            queries = uriQuery + "&" + (String)queries;
        }
        if (uriQuery != null) {
            String[] uriQueries = uriQuery.split("&");
            Arrays.stream(uriQueries).map(s -> s.split("=")).forEach(keyValue -> {
                if (((String[])keyValue).length == 1) {
                    this.queryParam("", keyValue[0]);
                } else {
                    this.queryParam(keyValue[0], keyValue[1]);
                }
            });
        }
        return queries;
    }

    private String resolvePath() {
        Object finalPath;
        String uriPath = this.uri.getRawPath();
        String extendedPath = this.path.toRawString();
        if (uriPath.endsWith("/") && extendedPath.startsWith("/")) {
            finalPath = uriPath.substring(0, uriPath.length() - 1) + extendedPath;
        } else if (extendedPath.isEmpty()) {
            finalPath = uriPath;
        } else {
            Object object = finalPath = uriPath.endsWith("/") || extendedPath.startsWith("/") ? uriPath + extendedPath : uriPath + "/" + extendedPath;
        }
        if (this.skipUriEncoding) {
            return finalPath;
        }
        return UriComponentEncoder.encode((String)finalPath, UriComponentEncoder.Type.PATH);
    }

    private HttpMethod toNettyMethod(Http.RequestMethod method) {
        return HttpMethod.valueOf((String)method.name());
    }

    private HttpVersion toNettyHttpVersion(Http.Version version) {
        return HttpVersion.valueOf((String)version.value());
    }

    private HttpHeaders toNettyHttpHeaders() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(this.configuration.validateHeaders());
        try {
            Map<String, List<String>> cookieHeaders = this.configuration.cookieManager().get(this.finalUri, new HashMap<String, List<String>>());
            ArrayList cookies = new ArrayList(cookieHeaders.get("Cookie"));
            cookies.addAll(this.headers.values("Cookie"));
            if (!cookies.isEmpty()) {
                headers.add("Cookie", (Object)String.join((CharSequence)"; ", cookies));
            }
        }
        catch (IOException e) {
            throw new WebClientException("An error occurred while setting cookies.", e);
        }
        this.headers.toMap().forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.HOST, this.finalUri.getHost() + ":" + this.finalUri.getPort());
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.CONNECTION, this.keepAlive ? HttpHeaderValues.KEEP_ALIVE : HttpHeaderValues.CLOSE);
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.ACCEPT_ENCODING, HttpHeaderValues.GZIP);
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.USER_AGENT, this.configuration.userAgent());
        return headers;
    }

    private void addHeaderIfAbsent(HttpHeaders headers, AsciiString header, Object headerValue) {
        if (!headers.contains((CharSequence)header)) {
            headers.set((CharSequence)header, headerValue);
        }
    }

    static {
        DEFAULT_SUPPORTED_PROTOCOLS.put(DEFAULT_TRANSPORT_PROTOCOL, 80);
        DEFAULT_SUPPORTED_PROTOCOLS.put("https", 443);
    }

    static class ConnectionIdent {
        private final URI base;
        private final Duration readTimeout;
        private final Proxy proxy;
        private final WebClientTls tls;

        private ConnectionIdent(RequestConfiguration requestConfiguration) {
            URI uri = requestConfiguration.requestURI();
            this.base = URI.create(uri.getScheme() + "://" + uri.getAuthority());
            this.readTimeout = requestConfiguration.readTimout();
            this.proxy = requestConfiguration.proxy().orElse(null);
            this.tls = requestConfiguration.tls();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionIdent that = (ConnectionIdent)o;
            return Objects.equals(this.base, that.base) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.proxy, that.proxy) && Objects.equals(this.tls, that.tls);
        }

        public int hashCode() {
            return Objects.hash(this.base, this.readTimeout, this.proxy, this.tls);
        }

        public String toString() {
            return "ConnectionIdent{base=" + this.base + ", readTimeout=" + this.readTimeout + ", proxy=" + this.proxy + ", tls=" + this.tls + "}";
        }
    }

    private static class ChannelRecord {
        private final ChannelFuture channelFuture;
        private final Channel channel;

        private ChannelRecord(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
            this.channel = channelFuture.channel();
        }

        private ChannelRecord(Channel channel) {
            this.channelFuture = null;
            this.channel = channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChannelRecord that = (ChannelRecord)o;
            return this.channel == that.channel;
        }

        public int hashCode() {
            return this.channel.hashCode();
        }
    }

    private static class ClientPath
    implements HttpRequest.Path {
        private final String path;
        private final String rawPath;
        private final Map<String, String> params;
        private final ClientPath absolutePath;
        private List<String> segments;

        ClientPath(String path, String rawPath, Map<String, String> params, ClientPath absolutePath) {
            this.path = path;
            this.rawPath = rawPath;
            this.params = params == null ? Collections.emptyMap() : params;
            this.absolutePath = absolutePath;
        }

        public String param(String name) {
            return this.params.get(name);
        }

        public List<String> segments() {
            List<String> result = this.segments;
            if (result == null) {
                StringTokenizer stok = new StringTokenizer(this.path, "/");
                result = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    result.add(stok.nextToken());
                }
                this.segments = result;
            }
            return result;
        }

        public String toString() {
            return this.path;
        }

        public String toRawString() {
            return this.rawPath;
        }

        public HttpRequest.Path absolute() {
            return this.absolutePath == null ? this : this.absolutePath;
        }

        static HttpRequest.Path create(ClientPath contextual, String path, Map<String, String> params) {
            return ClientPath.create(contextual, path, path, params);
        }

        static HttpRequest.Path create(ClientPath contextual, String path, String rawPath, Map<String, String> params) {
            if (contextual == null) {
                return new ClientPath(path, rawPath, params, null);
            }
            return contextual.createSubpath(path, rawPath, params);
        }

        HttpRequest.Path createSubpath(String path, String rawPath, Map<String, String> params) {
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (this.absolutePath == null) {
                HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size());
                map.putAll(this.params);
                map.putAll(params);
                return new ClientPath(path, rawPath, params, new ClientPath(this.path, this.rawPath, map, null));
            }
            int size = this.params.size() + params.size() + this.absolutePath.params.size();
            HashMap<String, String> map = new HashMap<String, String>(size);
            map.putAll(this.absolutePath.params);
            map.putAll(this.params);
            map.putAll(params);
            return new ClientPath(path, rawPath, params, new ClientPath(this.absolutePath.path, this.absolutePath.rawPath, map, null));
        }
    }
}

