/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.spi.WebClientService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class RequestConfiguration
extends WebClientConfiguration {
    private final URI requestURI;
    private final WebClientServiceRequest clientServiceRequest;
    private final List<WebClientService> services;

    private RequestConfiguration(Builder builder) {
        super(builder);
        this.requestURI = builder.requestURI;
        this.clientServiceRequest = builder.clientServiceRequest;
        this.services = builder.services;
    }

    URI requestURI() {
        return this.requestURI;
    }

    WebClientServiceRequest clientServiceRequest() {
        return this.clientServiceRequest;
    }

    List<WebClientService> services() {
        return this.services;
    }

    static Builder builder(URI requestURI) {
        return new Builder(requestURI);
    }

    static final class Builder
    extends WebClientConfiguration.Builder<Builder, RequestConfiguration> {
        private final URI requestURI;
        private WebClientServiceRequest clientServiceRequest;
        private List<WebClientService> services = new ArrayList<WebClientService>();

        private Builder(URI requestURI) {
            this.requestURI = requestURI;
        }

        Builder clientServiceRequest(WebClientServiceRequest clientServiceRequest) {
            this.clientServiceRequest = clientServiceRequest;
            return this;
        }

        Builder services(List<WebClientService> services) {
            this.services = Collections.unmodifiableList(services);
            return this;
        }

        @Override
        public RequestConfiguration build() {
            return new RequestConfiguration(this);
        }
    }
}

