/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public class WebClientTls {
    private final boolean trustAll;
    private final boolean disableHostnameVerification;
    private final PrivateKey clientPrivateKey;
    private final List<X509Certificate> certificates;
    private final List<X509Certificate> clientCertificateChain;
    private final SSLContext sslContext;

    private WebClientTls(Builder builder) {
        this.trustAll = builder.trustAll;
        this.disableHostnameVerification = builder.disableHostnameVerification;
        this.certificates = builder.certificates;
        this.clientPrivateKey = builder.clientPrivateKey;
        this.clientCertificateChain = builder.clientCertificateChain;
        this.sslContext = builder.sslContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    boolean trustAll() {
        return this.trustAll;
    }

    boolean disableHostnameVerification() {
        return this.disableHostnameVerification;
    }

    List<X509Certificate> certificates() {
        return this.certificates;
    }

    Optional<PrivateKey> clientPrivateKey() {
        return Optional.ofNullable(this.clientPrivateKey);
    }

    List<X509Certificate> clientCertificateChain() {
        return this.clientCertificateChain;
    }

    Optional<SSLContext> sslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    public static final class Builder
    implements io.helidon.common.Builder<WebClientTls> {
        private boolean trustAll = false;
        private boolean disableHostnameVerification = false;
        private PrivateKey clientPrivateKey;
        private List<X509Certificate> certificates = new ArrayList<X509Certificate>();
        private List<X509Certificate> clientCertificateChain = new ArrayList<X509Certificate>();
        private SSLContext sslContext;

        private Builder() {
        }

        public Builder disableHostnameVerification(boolean disableHostnameVerification) {
            this.disableHostnameVerification = disableHostnameVerification;
            return this;
        }

        public Builder trustAll(boolean trustAll) {
            this.trustAll = trustAll;
            return this;
        }

        public Builder certificateTrustStore(KeyConfig keyStore) {
            Objects.requireNonNull(keyStore);
            this.certificates = keyStore.certs();
            return this;
        }

        public Builder clientKeyStore(KeyConfig keyConfig) {
            Objects.requireNonNull(keyConfig);
            keyConfig.privateKey().ifPresent(privateKey -> {
                this.clientPrivateKey = privateKey;
            });
            this.clientCertificateChain = keyConfig.certChain();
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder config(Config config) {
            Config serverConfig = config.get("server");
            serverConfig.get("disable-hostname-verification").asBoolean().ifPresent(this::disableHostnameVerification);
            serverConfig.get("trust-all").asBoolean().ifPresent(this::trustAll);
            serverConfig.as(KeyConfig::create).ifPresent(this::certificateTrustStore);
            config.get("client").as(KeyConfig::create).ifPresent(this::clientKeyStore);
            return this;
        }

        public WebClientTls build() {
            return new WebClientTls(this);
        }
    }
}

