/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.DataChunk;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestImpl;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientServiceRequest;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.logging.Logger;

class RequestContentSubscriber
implements Flow.Subscriber<DataChunk> {
    private static final Logger LOGGER = Logger.getLogger(RequestContentSubscriber.class.getName());
    private static final LastHttpContent LAST_HTTP_CONTENT = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
    private final CompletableFuture<WebClientResponse> responseFuture;
    private final CompletableFuture<WebClientServiceRequest> sent;
    private final DefaultHttpRequest request;
    private final Channel channel;
    private volatile Flow.Subscription subscription;
    private volatile DataChunk firstDataChunk;
    private volatile boolean lengthOptimization = true;

    RequestContentSubscriber(DefaultHttpRequest request, Channel channel, CompletableFuture<WebClientResponse> responseFuture, CompletableFuture<WebClientServiceRequest> sent) {
        this.request = request;
        this.channel = channel;
        this.responseFuture = responseFuture;
        this.sent = sent;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
        LOGGER.finest(() -> "Writing sending request and its content to the server.");
    }

    @Override
    public void onNext(DataChunk data) {
        if (data.isFlushChunk()) {
            this.channel.flush();
            return;
        }
        if (this.lengthOptimization && this.firstDataChunk == null) {
            this.firstDataChunk = data.isReadOnly() ? data : data.duplicate();
            this.subscription.request(1L);
            return;
        }
        if (null != this.firstDataChunk) {
            this.lengthOptimization = false;
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.request, (boolean)true);
            this.channel.writeAndFlush((Object)this.request);
            this.sendData(this.firstDataChunk);
            this.firstDataChunk = null;
        }
        this.sendData(data);
    }

    @Override
    public void onError(Throwable throwable) {
        this.responseFuture.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        if (this.lengthOptimization) {
            LOGGER.finest(() -> "Message body contains only one data chunk. Setting chunked encoding to false.");
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.request, (boolean)false);
            if (this.firstDataChunk != null) {
                HttpUtil.setContentLength((HttpMessage)this.request, (long)this.firstDataChunk.data().remaining());
            }
            this.channel.writeAndFlush((Object)this.request);
            if (this.firstDataChunk != null) {
                this.sendData(this.firstDataChunk);
            }
        }
        LOGGER.finest(() -> "Sending last http content");
        this.channel.writeAndFlush((Object)LAST_HTTP_CONTENT).addListener(this.completeOnFailureListener("An exception occurred when writing last http content.")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        WebClientRequestImpl clientRequest = (WebClientRequestImpl)this.channel.attr(WebClientRequestBuilderImpl.REQUEST).get();
        WebClientServiceRequest serviceRequest = clientRequest.configuration().clientServiceRequest();
        this.sent.complete(serviceRequest);
    }

    private void sendData(DataChunk data) {
        LOGGER.finest(() -> "Sending data chunk");
        DefaultHttpContent httpContent = new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuffer)data.data()));
        this.channel.writeAndFlush((Object)httpContent).addListener(future -> {
            data.release();
            this.subscription.request(1L);
            LOGGER.finest(() -> "Data chunk sent with result: " + future.isSuccess());
        }).addListener(this.completeOnFailureListener("Failure when sending a content!")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    private GenericFutureListener<Future<? super Void>> completeOnFailureListener(String message) {
        return future -> {
            if (!future.isSuccess()) {
                this.completeRequestFuture(new IllegalStateException(message, future.cause()));
            }
        };
    }

    private void completeRequestFuture(Throwable throwable) {
        if (throwable != null) {
            this.responseFuture.completeExceptionally(throwable);
        }
    }
}

