/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.context.Context;
import io.helidon.common.http.HashParameters;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.Parameters;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.WebClientServiceResponse;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class WebClientServiceRequestImpl
implements WebClientServiceRequest {
    private final WebClientRequestHeaders headers;
    private final Context context;
    private final Http.RequestMethod method;
    private final Http.Version version;
    private final URI uri;
    private final String query;
    private final Parameters queryParams;
    private final HttpRequest.Path path;
    private final String fragment;
    private final HashParameters parameters;
    private final CompletionStage<WebClientServiceRequest> sent;
    private final CompletableFuture<WebClientServiceResponse> responseReceived;
    private final CompletableFuture<WebClientServiceResponse> complete;

    WebClientServiceRequestImpl(WebClientRequestBuilderImpl requestBuilder, CompletionStage<WebClientServiceRequest> sent, CompletableFuture<WebClientServiceResponse> responseReceived, CompletableFuture<WebClientServiceResponse> complete) {
        this.headers = requestBuilder.headers();
        this.context = requestBuilder.context();
        this.method = requestBuilder.method();
        this.version = requestBuilder.httpVersion();
        this.uri = requestBuilder.uri();
        this.query = requestBuilder.query();
        this.responseReceived = responseReceived;
        this.queryParams = this.queryParams();
        this.path = requestBuilder.path();
        this.fragment = requestBuilder.fragment();
        this.parameters = HashParameters.create(requestBuilder.properties());
        this.sent = sent;
        this.complete = complete;
    }

    @Override
    public WebClientRequestHeaders headers() {
        return this.headers;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public CompletionStage<WebClientServiceRequest> whenSent() {
        return this.sent;
    }

    @Override
    public CompletionStage<WebClientServiceResponse> whenResponseReceived() {
        return this.responseReceived;
    }

    @Override
    public CompletionStage<WebClientServiceResponse> whenComplete() {
        return this.complete;
    }

    @Override
    public Parameters properties() {
        return this.parameters;
    }

    public Http.RequestMethod method() {
        return this.method;
    }

    public Http.Version version() {
        return this.version;
    }

    public URI uri() {
        return this.uri;
    }

    public String query() {
        return this.query;
    }

    public Parameters queryParams() {
        return this.queryParams;
    }

    public HttpRequest.Path path() {
        return this.path;
    }

    public String fragment() {
        return this.fragment;
    }
}

