/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.webclient.NettyClientHandler;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientResponseHeaders;
import io.helidon.webclient.WebClientResponseHeadersImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.logging.Logger;

final class WebClientResponseImpl
implements WebClientResponse {
    private static final Logger LOGGER = Logger.getLogger(NettyClientHandler.class.getName());
    private final WebClientResponseHeadersImpl headers;
    private final Flow.Publisher<DataChunk> publisher;
    private final Http.ResponseStatus status;
    private final Http.Version version;
    private final MediaSupport mediaSupport;
    private final Set<MessageBodyReader<?>> requestReaders;
    private final NettyClientHandler.ResponseCloser responseCloser;

    private WebClientResponseImpl(Builder builder) {
        this.headers = WebClientResponseHeadersImpl.create(builder.headers);
        this.publisher = builder.publisher;
        this.status = builder.status;
        this.version = builder.version;
        this.mediaSupport = builder.mediaSupport;
        this.requestReaders = builder.requestReaders;
        this.responseCloser = builder.responseCloser;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Http.ResponseStatus status() {
        return this.status;
    }

    @Override
    public Http.Version version() {
        return this.version;
    }

    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> toReturn = new CompletableFuture<Void>();
        this.responseCloser.close().addListener(future -> {
            LOGGER.finest("Response has been closed.");
            toReturn.complete(null);
        });
        return toReturn;
    }

    @Override
    public MessageBodyReadableContent content() {
        Optional<MediaType> mediaType = this.headers.contentType();
        MessageBodyReaderContext readerContext = MessageBodyReaderContext.create((MediaSupport)this.mediaSupport, null, (ReadOnlyParameters)this.headers, mediaType);
        this.requestReaders.forEach(arg_0 -> ((MessageBodyReaderContext)readerContext).registerReader(arg_0));
        return MessageBodyReadableContent.create(this.publisher, (MessageBodyReaderContext)readerContext);
    }

    @Override
    public WebClientResponseHeaders headers() {
        return this.headers;
    }

    static class Builder
    implements io.helidon.common.Builder<WebClientResponseImpl> {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private MediaSupport mediaSupport;
        private Flow.Publisher<DataChunk> publisher;
        private Http.ResponseStatus status = Http.Status.INTERNAL_SERVER_ERROR_500;
        private Http.Version version = Http.Version.V1_1;
        private Set<MessageBodyReader<?>> requestReaders;
        private NettyClientHandler.ResponseCloser responseCloser;

        Builder() {
        }

        public WebClientResponseImpl build() {
            return new WebClientResponseImpl(this);
        }

        Builder contentPublisher(Flow.Publisher<DataChunk> publisher) {
            this.publisher = publisher;
            return this;
        }

        Builder requestBodyReaders(Set<MessageBodyReader<?>> requestReaders) {
            this.requestReaders = requestReaders;
            return this;
        }

        Builder mediaSupport(MediaSupport mediaSupport) {
            this.mediaSupport = mediaSupport;
            return this;
        }

        Builder status(Http.ResponseStatus status) {
            this.status = status;
            return this;
        }

        Builder httpVersion(Http.Version version) {
            this.version = version;
            return this;
        }

        Builder addHeader(String name, List<String> values) {
            this.headers.put(name, values);
            return this;
        }

        Builder responseCloser(NettyClientHandler.ResponseCloser responseCloser) {
            this.responseCloser = responseCloser;
            return this;
        }
    }
}

