/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.Http;
import io.helidon.webclient.HttpInterceptor;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;

class RedirectInterceptor
implements HttpInterceptor {
    private static final Logger LOGGER = Logger.getLogger(RedirectInterceptor.class.getName());

    RedirectInterceptor() {
    }

    @Override
    public void handleInterception(HttpResponse httpResponse, WebClientRequestBuilder.ClientRequest clientRequest, CompletableFuture<WebClientResponse> responseFuture) {
        if (clientRequest.method() != Http.Method.GET) {
            throw new WebClientException("Redirecting is currently supported only for GET method.");
        }
        if (!httpResponse.headers().contains("Location")) {
            throw new WebClientException("There is no Location header present in response! It is not clear where to redirect.");
        }
        String newUri = httpResponse.headers().get("Location");
        LOGGER.fine(() -> "Redirecting to " + newUri);
        CompletionStage<WebClientResponse> redirectResponse = WebClientRequestBuilderImpl.create(clientRequest).uri(newUri).request(WebClientResponse.class);
        redirectResponse.whenComplete((clResponse, throwable) -> {
            if (throwable == null) {
                responseFuture.complete((WebClientResponse)clResponse);
            } else {
                responseFuture.completeExceptionally((Throwable)throwable);
            }
        });
    }

    @Override
    public boolean continueAfterInterception() {
        return false;
    }

    @Override
    public boolean shouldIntercept(HttpResponseStatus responseStatus, WebClientConfiguration configuration) {
        if (!configuration.followRedirects()) {
            return false;
        }
        return responseStatus.equals((Object)HttpResponseStatus.MOVED_PERMANENTLY) || responseStatus.equals((Object)HttpResponseStatus.FOUND) || responseStatus.equals((Object)HttpResponseStatus.SEE_OTHER) || responseStatus.equals((Object)HttpResponseStatus.TEMPORARY_REDIRECT) || responseStatus.equals((Object)HttpResponseStatus.PERMANENT_REDIRECT);
    }
}

