/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.websocket;

import io.helidon.builder.api.RuntimeType;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.spi.Protocol;
import io.helidon.webclient.websocket.WsClientConfig;
import io.helidon.webclient.websocket.WsClientImpl;
import io.helidon.webclient.websocket.WsClientProtocolConfig;
import io.helidon.webclient.websocket.WsProtocolProvider;
import io.helidon.websocket.WsListener;
import java.net.URI;
import java.util.function.Consumer;

public interface WsClient
extends RuntimeType.Api<WsClientConfig> {
    public static final Protocol<WsClient, WsClientProtocolConfig> PROTOCOL = WsProtocolProvider::new;

    public static WsClientConfig.Builder builder() {
        return WsClientConfig.builder();
    }

    public static WsClient create(WsClientConfig clientConfig) {
        WebClient webClient = WebClient.create((T it) -> it.from((HttpClientConfig)clientConfig));
        return new WsClientImpl(webClient, (Http1Client)webClient.client(Http1Client.PROTOCOL), clientConfig);
    }

    public static WsClient create(Consumer<WsClientConfig.Builder> consumer) {
        return ((WsClientConfig.Builder)WsClientConfig.builder().update(consumer)).build();
    }

    public void connect(URI var1, WsListener var2);

    public void connect(String var1, WsListener var2);
}

