/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.metrics.WebClientMetric;
import io.helidon.webclient.metrics.WebClientMetricType;
import io.helidon.webclient.spi.WebClientService;
import java.util.ArrayList;
import java.util.List;

public class WebClientMetrics
implements WebClientService {
    private final List<WebClientMetric> metrics;

    private WebClientMetrics(Builder builder) {
        this.metrics = builder.metrics;
    }

    public static WebClientMetric.Builder timer() {
        return WebClientMetric.builder(WebClientMetricType.TIMER);
    }

    public static WebClientMetric.Builder counter() {
        return WebClientMetric.builder(WebClientMetricType.COUNTER);
    }

    public static WebClientMetric.Builder meter() {
        return WebClientMetric.builder(WebClientMetricType.METER);
    }

    public static WebClientMetric.Builder gaugeInProgress() {
        return WebClientMetric.builder(WebClientMetricType.GAUGE_IN_PROGRESS);
    }

    public static WebClientMetrics create(Config config) {
        Builder builder = new Builder();
        config.asNodeList().ifPresent(configs -> configs.forEach(metricConfig -> builder.register(WebClientMetrics.processClientMetric(metricConfig))));
        return builder.build();
    }

    private static WebClientMetric processClientMetric(Config metricConfig) {
        String type;
        switch (type = (String)metricConfig.get("type").asString().orElse((Object)"COUNTER")) {
            case "COUNTER": {
                return WebClientMetrics.counter().config(metricConfig).build();
            }
            case "METER": {
                return WebClientMetrics.meter().config(metricConfig).build();
            }
            case "TIMER": {
                return WebClientMetrics.timer().config(metricConfig).build();
            }
            case "GAUGE_IN_PROGRESS": {
                return WebClientMetrics.gaugeInProgress().config(metricConfig).build();
            }
        }
        throw new WebClientException("Metrics type " + type + " is not supported through service loader");
    }

    public Single<WebClientServiceRequest> request(WebClientServiceRequest request) {
        this.metrics.forEach(clientMetric -> clientMetric.request(request));
        return Single.just((Object)request);
    }

    public Single<WebClientServiceResponse> response(WebClientRequestBuilder.ClientRequest request, WebClientServiceResponse response) {
        this.metrics.forEach(clientMetric -> clientMetric.response(request, response));
        return Single.just((Object)response);
    }

    private static final class Builder
    implements io.helidon.common.Builder<WebClientMetrics> {
        private final List<WebClientMetric> metrics = new ArrayList<WebClientMetric>();

        private Builder() {
        }

        private Builder register(WebClientMetric clientMetric) {
            this.metrics.add(clientMetric);
            return this;
        }

        public WebClientMetrics build() {
            return new WebClientMetrics(this);
        }
    }
}

