/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jsonrpc;

import io.helidon.http.HeaderNames;
import io.helidon.jsonrpc.core.JsonUtil;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchRequest;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchResponseImpl;
import io.helidon.webclient.jsonrpc.JsonRpcClientRequest;
import io.helidon.webclient.jsonrpc.JsonRpcClientRequestImpl;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.List;

class JsonRpcClientBatchRequestImpl
implements JsonRpcClientBatchRequest {
    private final Http1Client http1Client;
    private final Http1ClientRequest delegate;
    private final List<JsonRpcClientRequest> requests = new ArrayList<JsonRpcClientRequest>();

    JsonRpcClientBatchRequestImpl(Http1Client http1Client, String path) {
        this.http1Client = http1Client;
        this.delegate = (Http1ClientRequest)http1Client.post(path);
    }

    @Override
    public JsonRpcClientRequest rpcMethod(String rpcMethod) {
        return new JsonRpcClientRequestImpl(this.http1Client, rpcMethod, this);
    }

    @Override
    public JsonRpcClientBatchResponse submit() {
        Http1ClientResponse res = ((Http1ClientRequest)((Http1ClientRequest)this.delegate.header(HeaderNames.CONTENT_TYPE, new String[]{"application/json"})).header(HeaderNames.ACCEPT, new String[]{"application/json"})).submit((Object)this.asJsonArray());
        return new JsonRpcClientBatchResponseImpl((HttpClientResponse)res);
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArrayBuilder arrayBuilder = JsonUtil.JSON_BUILDER_FACTORY.createArrayBuilder();
        this.requests.forEach(request -> arrayBuilder.add((JsonValue)request.asJsonObject()));
        return arrayBuilder.build();
    }

    void add(JsonRpcClientRequest request) {
        this.requests.add(request);
    }
}

