/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jsonrpc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.jsonrpc.JsonRpcClient;
import io.helidon.webclient.jsonrpc.JsonRpcClientConfigBlueprint;
import io.helidon.webclient.jsonrpc.JsonRpcClientProtocolConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.jsonrpc.JsonRpcClientConfigBlueprint")
public interface JsonRpcClientConfig
extends JsonRpcClientConfigBlueprint,
Prototype.Api,
HttpClientConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JsonRpcClientConfig instance) {
        return (Builder)((Object)JsonRpcClientConfig.builder().from(instance));
    }

    public static JsonRpcClientConfig create(Config config) {
        return ((Builder)JsonRpcClientConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static JsonRpcClientConfig create(io.helidon.common.config.Config config) {
        return JsonRpcClientConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static JsonRpcClientConfig create() {
        return JsonRpcClientConfig.builder().buildPrototype();
    }

    @Override
    public JsonRpcClientProtocolConfig protocolConfig();

    public static class Builder
    extends BuilderBase<Builder, JsonRpcClientConfig>
    implements io.helidon.common.Builder<Builder, JsonRpcClient> {
        private Builder() {
        }

        public JsonRpcClientConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.JsonRpcClientConfigImpl(this);
        }

        public JsonRpcClient build() {
            return JsonRpcClient.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends JsonRpcClientConfig>
    extends HttpClientConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private JsonRpcClientProtocolConfig protocolConfig = JsonRpcClientProtocolConfig.create();

        protected BuilderBase() {
        }

        public BUILDER from(JsonRpcClientConfig prototype) {
            super.from((HttpClientConfig)prototype);
            this.protocolConfig(prototype.protocolConfig());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.protocolConfig(builder.protocolConfig());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("protocol-config").as(JsonRpcClientProtocolConfig::create).ifPresent(this::protocolConfig);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(JsonRpcClientProtocolConfig protocolConfig) {
            Objects.requireNonNull(protocolConfig);
            this.protocolConfig = protocolConfig;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(Consumer<JsonRpcClientProtocolConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            JsonRpcClientProtocolConfig.Builder builder = JsonRpcClientProtocolConfig.builder();
            consumer.accept(builder);
            this.protocolConfig(builder.build());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(Supplier<? extends JsonRpcClientProtocolConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.protocolConfig(supplier.get());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public JsonRpcClientProtocolConfig protocolConfig() {
            return this.protocolConfig;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "JsonRpcClientConfigBuilder{protocolConfig=" + String.valueOf(this.protocolConfig) + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        protected void validatePrototype() {
            super.validatePrototype();
        }

        protected static class JsonRpcClientConfigImpl
        extends HttpClientConfig.BuilderBase.HttpClientConfigImpl
        implements JsonRpcClientConfig,
        Supplier<JsonRpcClient> {
            private final JsonRpcClientProtocolConfig protocolConfig;

            protected JsonRpcClientConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.protocolConfig = builder.protocolConfig();
            }

            public JsonRpcClient build() {
                return JsonRpcClient.create(this);
            }

            @Override
            public JsonRpcClient get() {
                return this.build();
            }

            @Override
            public JsonRpcClientProtocolConfig protocolConfig() {
                return this.protocolConfig;
            }

            public String toString() {
                return "JsonRpcClientConfig{protocolConfig=" + String.valueOf(this.protocolConfig) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JsonRpcClientConfig)) {
                    return false;
                }
                JsonRpcClientConfig other = (JsonRpcClientConfig)o;
                return super.equals((Object)other) && Objects.equals(this.protocolConfig, other.protocolConfig());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.protocolConfig);
            }
        }
    }
}

