/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jsonrpc;

import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.ClientResponseTrailers;
import io.helidon.http.HeaderNames;
import io.helidon.http.Status;
import io.helidon.http.media.ReadableEntity;
import io.helidon.jsonrpc.core.JsonRpcError;
import io.helidon.jsonrpc.core.JsonRpcResult;
import io.helidon.jsonrpc.core.JsonUtil;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientResponse;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Objects;
import java.util.Optional;

class JsonRpcClientResponseImpl
implements JsonRpcClientResponse {
    private static final JsonObject EMPTY_JSON_OBJECT = JsonUtil.JSON_BUILDER_FACTORY.createObjectBuilder().build();
    private final HttpClientResponse delegate;
    private JsonObject jsonObject;

    JsonRpcClientResponseImpl(HttpClientResponse delegate) {
        this(delegate, null);
    }

    JsonRpcClientResponseImpl(HttpClientResponse delegate, JsonObject jsonObject) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.jsonObject = jsonObject;
    }

    @Override
    public Optional<JsonValue> rpcId() {
        JsonValue id = (JsonValue)this.asJsonObject().get((Object)"id");
        return Optional.ofNullable(id);
    }

    @Override
    public Optional<JsonRpcResult> result() {
        JsonValue result = (JsonValue)this.asJsonObject().get((Object)"result");
        return result == null ? Optional.empty() : Optional.of(JsonRpcResult.create((JsonValue)result));
    }

    @Override
    public Optional<JsonRpcError> error() {
        try {
            JsonObject error = this.asJsonObject().getJsonObject("error");
            return Optional.of(JsonRpcError.create((JsonObject)error));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public JsonObject asJsonObject() {
        if (this.jsonObject == null) {
            ClientResponseHeaders headers = this.delegate.headers();
            if (headers.contains(HeaderNames.CONTENT_TYPE)) {
                Optional contentType = headers.first(HeaderNames.CONTENT_TYPE);
                if (contentType.isEmpty() || !((String)contentType.get()).equalsIgnoreCase("application/json")) {
                    throw new IllegalStateException("Response contains invalid Content-Type header");
                }
                this.jsonObject = (JsonObject)this.delegate.entity().as(JsonObject.class);
            } else {
                this.jsonObject = EMPTY_JSON_OBJECT;
            }
        }
        return this.jsonObject;
    }

    public ReadableEntity entity() {
        return this.delegate.entity();
    }

    public void close() {
        this.delegate.close();
    }

    public Status status() {
        return this.delegate.status();
    }

    public ClientResponseHeaders headers() {
        return this.delegate.headers();
    }

    public ClientResponseTrailers trailers() {
        return this.delegate.trailers();
    }

    public ClientUri lastEndpointUri() {
        return this.delegate.lastEndpointUri();
    }
}

