/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jsonrpc;

import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webclient.jsonrpc.JsonRpcClient;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchRequest;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchRequestImpl;
import io.helidon.webclient.jsonrpc.JsonRpcClientConfig;
import io.helidon.webclient.jsonrpc.JsonRpcClientRequest;
import io.helidon.webclient.jsonrpc.JsonRpcClientRequestImpl;
import java.util.Objects;

class JsonRpcClientImpl
implements JsonRpcClient {
    private final Http1Client http1Client;
    private final JsonRpcClientConfig clientConfig;

    JsonRpcClientImpl(JsonRpcClientConfig clientConfig) {
        this.http1Client = ((Http1ClientConfig.Builder)Http1Client.builder().from((HttpClientConfig)clientConfig)).build();
        this.clientConfig = clientConfig;
    }

    public JsonRpcClientConfig prototype() {
        return this.clientConfig;
    }

    @Override
    public JsonRpcClientRequest rpcMethod(String rpcMethod) {
        Objects.requireNonNull(rpcMethod, "rpcMethod is null");
        return new JsonRpcClientRequestImpl(this.http1Client, rpcMethod);
    }

    @Override
    public JsonRpcClientBatchRequest batch(String path) {
        return new JsonRpcClientBatchRequestImpl(this.http1Client, path);
    }
}

