/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.webclient.api.HttpClient;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http2.Http2ClientConfig;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientRequest;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=Http2ClientConfig.class)
public interface Http2Client
extends HttpClient<Http2ClientRequest>,
RuntimeType.Api<Http2ClientConfig> {
    public static final String PROTOCOL_ID = "h2";

    public static Http2ClientConfig.Builder builder() {
        return Http2ClientConfig.builder();
    }

    public static Http2Client create(Http2ClientConfig clientConfig) {
        return new Http2ClientImpl(WebClient.create((T it) -> it.from((HttpClientConfig)clientConfig)), clientConfig);
    }

    public static Http2Client create(Consumer<Http2ClientConfig.Builder> consumer) {
        return Http2Client.create(((Http2ClientConfig.Builder)Http2ClientConfig.builder().update(consumer)).buildPrototype());
    }

    public static Http2Client create() {
        return Http2Client.create(Http2ClientConfig.create());
    }

    public static Http2Client create(Config config) {
        return Http2Client.create((Http2ClientConfig.Builder it) -> it.config(config));
    }
}

