/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameListener;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2HuffmanDecoder;
import io.helidon.http.http2.Http2LoggingFrameListener;
import io.helidon.http.http2.Http2Priority;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Setting;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2Stream;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.webclient.api.ReleasableResource;
import io.helidon.webclient.http2.Http2ClientConfig;
import io.helidon.webclient.http2.Http2ClientConnection;
import io.helidon.webclient.http2.Http2StreamConfig;
import io.helidon.webclient.http2.LockingStreamIdSequence;
import io.helidon.webclient.http2.StreamBuffer;
import io.helidon.webclient.http2.StreamTimeoutException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

class Http2ClientStream
implements Http2Stream,
ReleasableResource {
    private static final System.Logger LOGGER = System.getLogger(Http2ClientStream.class.getName());
    private static final Set<Http2StreamState> NON_CANCELABLE = Set.of(Http2StreamState.CLOSED, Http2StreamState.IDLE);
    private final Http2ClientConnection connection;
    private final Http2Settings serverSettings;
    private final SocketContext ctx;
    private final Duration timeout;
    private final Http2ClientConfig http2ClientConfig;
    private final LockingStreamIdSequence streamIdSeq;
    private final Http2FrameListener sendListener = new Http2LoggingFrameListener("cl-send");
    private final Http2FrameListener recvListener = new Http2LoggingFrameListener("cl-recv");
    private final Http2Settings settings = Http2Settings.create();
    private final List<Http2FrameData> continuationData = new ArrayList<Http2FrameData>();
    private final CompletableFuture<Headers> trailers = new CompletableFuture();
    private Http2StreamState state = Http2StreamState.IDLE;
    private ReadState readState = ReadState.INIT;
    private Http2Headers currentHeaders;
    private volatile StreamFlowControl flowControl;
    private boolean hasEntity;
    private int streamId;
    private StreamBuffer buffer;

    Http2ClientStream(Http2ClientConnection connection, Http2Settings serverSettings, SocketContext ctx, Http2StreamConfig http2StreamConfig, Http2ClientConfig http2ClientConfig, LockingStreamIdSequence streamIdSeq) {
        this.connection = connection;
        this.serverSettings = serverSettings;
        this.ctx = ctx;
        this.timeout = http2StreamConfig.readTimeout();
        this.http2ClientConfig = http2ClientConfig;
        this.streamIdSeq = streamIdSeq;
    }

    public int streamId() {
        return this.streamId;
    }

    public Http2StreamState streamState() {
        return this.state;
    }

    public void headers(Http2Headers headers, boolean endOfStream) {
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.HEADERS, (boolean)false, (boolean)endOfStream, (boolean)true);
        this.readState = this.readState.check(endOfStream ? ReadState.END : ReadState.DATA);
        this.currentHeaders = headers;
        this.hasEntity = !endOfStream;
    }

    public boolean rstStream(Http2RstStream rstStream) {
        if (this.state == Http2StreamState.IDLE) {
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received RST_STREAM for stream " + this.streamId + " in IDLE state");
        }
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.RST_STREAM, (boolean)false, (boolean)false, (boolean)false);
        throw new RuntimeException("Reset of " + this.streamId + " stream received!");
    }

    public void windowUpdate(Http2WindowUpdate windowUpdate) {
        Http2RstStream frame;
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.WINDOW_UPDATE, (boolean)false, (boolean)false, (boolean)false);
        int increment = windowUpdate.windowSizeIncrement();
        if (increment == 0) {
            frame = new Http2RstStream(Http2ErrorCode.PROTOCOL);
            this.connection.writer().write(frame.toFrameData(this.serverSettings, this.streamId, Http2Flag.NoFlags.create()));
        }
        if (this.flowControl.outbound().incrementStreamWindowSize(increment) > Integer.MAX_VALUE) {
            frame = new Http2RstStream(Http2ErrorCode.FLOW_CONTROL);
            this.connection.writer().write(frame.toFrameData(this.serverSettings, this.streamId, Http2Flag.NoFlags.create()));
        }
        this.flowControl().outbound().incrementStreamWindowSize(increment);
    }

    public void data(Http2FrameHeader header, BufferData data, boolean endOfStream) {
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)header.type(), (boolean)false, (boolean)endOfStream, (boolean)false);
        this.readState = this.readState.check(endOfStream ? ReadState.END : ReadState.DATA);
        this.flowControl.inbound().incrementWindowSize(header.length());
    }

    public void priority(Http2Priority http2Priority) {
    }

    public StreamFlowControl flowControl() {
        return this.flowControl;
    }

    public void closeResource() {
        this.close();
    }

    void trailers(Http2Headers headers, boolean endOfStream) {
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.HEADERS, (boolean)false, (boolean)endOfStream, (boolean)true);
        this.readState = this.readState.check(ReadState.END);
        this.trailers.complete(headers.httpHeaders());
    }

    CompletableFuture<Headers> trailers() {
        return this.trailers;
    }

    boolean hasEntity() {
        return this.hasEntity;
    }

    void cancel() {
        if (NON_CANCELABLE.contains(this.state)) {
            return;
        }
        Http2RstStream rstStream = new Http2RstStream(Http2ErrorCode.CANCEL);
        Http2FrameData frameData = rstStream.toFrameData(this.settings, this.streamId, Http2Flag.NoFlags.create());
        this.sendListener.frameHeader(this.ctx, this.streamId, frameData.header());
        this.sendListener.frame(this.ctx, this.streamId, rstStream);
        try {
            this.write(frameData, false);
        }
        catch (UncheckedIOException e) {
            this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "Exception during stream cancel", (Throwable)e, new Object[0]);
        }
    }

    void close() {
        this.connection.removeStream(this.streamId);
    }

    void push(Http2FrameData frameData) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "%d: received frame of type %s, pushing to buffer", new Object[]{this.streamId, frameData.header().type()});
        }
        this.buffer.push(frameData);
    }

    BufferData read(int i) {
        return this.read();
    }

    BufferData read() {
        while (this.state == Http2StreamState.HALF_CLOSED_LOCAL && this.readState != ReadState.END && this.hasEntity) {
            Http2FrameData frameData = this.readOne(this.timeout);
            if (frameData == null) continue;
            return frameData.data();
        }
        return BufferData.empty();
    }

    Status waitFor100Continue() {
        Duration readContinueTimeout = this.http2ClientConfig.readContinueTimeout();
        boolean expected100Continue = this.readState == ReadState.CONTINUE_100_HEADERS;
        try {
            while (this.readState == ReadState.CONTINUE_100_HEADERS) {
                this.readOne(readContinueTimeout);
            }
        }
        catch (StreamTimeoutException ignored) {
            this.readState = this.readState.check(ReadState.HEADERS);
            LOGGER.log(System.Logger.Level.DEBUG, "Server didn't respond within 100 Continue timeout in " + String.valueOf(readContinueTimeout) + ", sending data.");
            return Status.CONTINUE_100;
        }
        if (expected100Continue && this.currentHeaders != null) {
            return this.currentHeaders.status();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHeaders(Http2Headers http2Headers, boolean endOfStream) {
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)Http2FrameType.HEADERS, (boolean)true, (boolean)endOfStream, (boolean)true);
        this.readState = this.readState.check(http2Headers.httpHeaders().contains(HeaderValues.EXPECT_100) ? ReadState.CONTINUE_100_HEADERS : ReadState.HEADERS);
        Http2Flag.HeaderFlags flags = endOfStream ? Http2Flag.HeaderFlags.create((int)5) : Http2Flag.HeaderFlags.create((int)4);
        try {
            this.streamId = this.streamIdSeq.lockAndNext();
            this.connection.updateLastStreamId(this.streamId);
            this.buffer = new StreamBuffer(this, this.streamId);
            this.flowControl = this.connection.flowControl().createStreamFlowControl(this.streamId, 65535, 16384);
            this.connection.addStream(this.streamId, this);
            this.sendListener.headers(this.ctx, this.streamId, http2Headers);
            this.connection.writer().writeHeaders(http2Headers, this.streamId, flags, this.flowControl.outbound());
        }
        finally {
            this.streamIdSeq.unlock();
        }
    }

    void writeData(BufferData entityBytes, boolean endOfStream) {
        Http2FrameHeader frameHeader = Http2FrameHeader.create((int)entityBytes.available(), (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)(endOfStream ? 1 : 0)), (int)this.streamId);
        Http2FrameData frameData = new Http2FrameData(frameHeader, entityBytes);
        this.splitAndWrite(frameData);
    }

    Http2Headers readHeaders() {
        while (this.readState == ReadState.HEADERS) {
            Http2FrameData frameData = this.readOne(this.timeout);
            if (frameData == null) continue;
            throw new IllegalStateException("Unexpected frame type " + String.valueOf(frameData.header()) + ", HEADERS are expected.");
        }
        return this.currentHeaders;
    }

    SocketContext ctx() {
        return this.ctx;
    }

    private Http2FrameData readOne(Duration pollTimeout) {
        Http2FrameData frameData = this.buffer.poll(pollTimeout);
        if (frameData != null) {
            this.recvListener.frameHeader(this.ctx, this.streamId, frameData.header());
            this.recvListener.frame(this.ctx, this.streamId, frameData.data());
            int flags = frameData.header().flags();
            boolean endOfStream = (flags & 1) == 1;
            boolean endOfHeaders = (flags & 4) == 4;
            block0 : switch (frameData.header().type()) {
                case DATA: {
                    this.data(frameData.header(), frameData.data(), endOfStream);
                    return frameData;
                }
                case HEADERS: 
                case CONTINUATION: {
                    this.continuationData.add(frameData);
                    if (!endOfHeaders) break;
                    Http2HuffmanDecoder requestHuffman = Http2HuffmanDecoder.create();
                    switch (this.readState.ordinal()) {
                        case 4: {
                            Http2Headers http2Headers = this.readHeaders(requestHuffman, false);
                            this.continuationData.clear();
                            this.continue100(http2Headers, endOfStream);
                            break block0;
                        }
                        case 3: {
                            Http2Headers http2Headers = this.readHeaders(requestHuffman, true);
                            this.continuationData.clear();
                            this.headers(http2Headers, endOfStream);
                            break block0;
                        }
                        case 1: 
                        case 2: {
                            Http2Headers http2Headers = this.readHeaders(requestHuffman, false);
                            this.trailers(http2Headers, endOfStream);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Client is in wrong read state " + this.readState.name());
                }
                default: {
                    LOGGER.log(System.Logger.Level.DEBUG, "Dropping frame " + String.valueOf(frameData.header()) + " expected header or data.");
                }
            }
        }
        return null;
    }

    private void continue100(Http2Headers headers, boolean endOfStream) {
        this.currentHeaders = headers;
        this.readState = endOfStream ? this.readState.check(ReadState.END) : (headers.status() == Status.CONTINUE_100 ? this.readState.check(ReadState.HEADERS) : this.readState.check(ReadState.DATA));
        this.hasEntity = !endOfStream;
    }

    private Http2Headers readHeaders(Http2HuffmanDecoder decoder, boolean mergeWithPrevious) {
        Http2Headers http2Headers = Http2Headers.create((Http2Stream)this, (Http2Headers.DynamicTable)this.connection.getInboundDynamicTable(), (Http2HuffmanDecoder)decoder, (Http2Headers)(mergeWithPrevious && this.currentHeaders != null ? this.currentHeaders : Http2Headers.create((WritableHeaders)WritableHeaders.create())), (Http2FrameData[])this.continuationData.toArray(new Http2FrameData[0]));
        this.recvListener.headers(this.ctx, this.streamId, http2Headers);
        return http2Headers;
    }

    private void splitAndWrite(Http2FrameData frameData) {
        Http2FrameData[] frames;
        int maxFrameSize = ((Long)this.serverSettings.value(Http2Setting.MAX_FRAME_SIZE)).intValue();
        for (Http2FrameData frame : frames = frameData.split(maxFrameSize)) {
            this.write(frame, ((Http2Flag.DataFlags)frame.header().flags(Http2FrameTypes.DATA)).endOfStream());
        }
    }

    private void write(Http2FrameData frameData, boolean endOfStream) {
        this.state = Http2StreamState.checkAndGetState((Http2StreamState)this.state, (Http2FrameType)frameData.header().type(), (boolean)true, (boolean)endOfStream, (boolean)false);
        this.connection.writer().writeData(frameData, this.flowControl().outbound());
    }

    static enum ReadState {
        END(new ReadState[0]),
        TRAILERS(END),
        DATA(TRAILERS, END),
        HEADERS(DATA, TRAILERS, END),
        CONTINUE_100_HEADERS(HEADERS, DATA, END),
        INIT(CONTINUE_100_HEADERS, HEADERS);

        private final Set<ReadState> allowedTransitions;

        private ReadState(ReadState ... allowedTransitions) {
            this.allowedTransitions = Set.of(allowedTransitions);
        }

        ReadState check(ReadState newState) {
            if (this == newState || this.allowedTransitions.contains((Object)newState)) {
                return newState;
            }
            throw new IllegalStateException("Transition from " + String.valueOf((Object)this) + " to " + String.valueOf((Object)newState) + " is not allowed!");
        }
    }
}

