/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Http;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.ReadableEntity;
import io.helidon.webclient.api.ClientResponseEntity;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.http2.Http2ClientResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

class Http2ClientResponseImpl
implements Http2ClientResponse {
    private final Http.Status responseStatus;
    private final ClientRequestHeaders requestHeaders;
    private final ClientResponseHeaders responseHeaders;
    private final CompletableFuture<Void> complete;
    private final Runnable closeResponseRunnable;
    private final InputStream inputStream;
    private final MediaContext mediaContext;
    private final ClientUri lastEndpointUri;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    Http2ClientResponseImpl(Http.Status status, ClientRequestHeaders requestHeaders, ClientResponseHeaders responseHeaders, InputStream inputStream, MediaContext mediaContext, ClientUri lastEndpointUri, CompletableFuture<Void> complete, Runnable closeResponseRunnable) {
        this.responseStatus = status;
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
        this.inputStream = inputStream;
        this.mediaContext = mediaContext;
        this.lastEndpointUri = lastEndpointUri;
        this.complete = complete;
        this.closeResponseRunnable = closeResponseRunnable;
    }

    public Http.Status status() {
        return this.responseStatus;
    }

    public ClientResponseHeaders headers() {
        return this.responseHeaders;
    }

    public ReadableEntity entity() {
        if (this.inputStream == null) {
            return ClientResponseEntity.empty();
        }
        return ClientResponseEntity.create(this::readBytes, this::close, (ClientRequestHeaders)this.requestHeaders, (ClientResponseHeaders)this.responseHeaders, (MediaContext)this.mediaContext);
    }

    private BufferData readBytes(int estimate) {
        try {
            byte[] buffer = new byte[estimate > 0 ? estimate : 16];
            int read = this.inputStream.read(buffer);
            if (read < 1) {
                return BufferData.empty();
            }
            return BufferData.create((byte[])buffer, (int)0, (int)read);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClientUri lastEndpointUri() {
        return this.lastEndpointUri;
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.complete.complete(null);
            this.closeResponseRunnable.run();
        }
    }
}

