/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.http2.Http2Headers;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http2.Http2CallChainBase;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ClientStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;

class Http2CallOutputStreamChain
extends Http2CallChainBase {
    private final CompletableFuture<WebClientServiceRequest> whenSent;
    private final ClientRequest.OutputStreamHandler streamHandler;

    Http2CallOutputStreamChain(Http2ClientImpl http2Client, Http2ClientRequestImpl http2ClientRequest, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete, ClientRequest.OutputStreamHandler streamHandler) {
        super(http2Client, http2ClientRequest, whenComplete, req -> req.outputStream(streamHandler));
        this.whenSent = whenSent;
        this.streamHandler = streamHandler;
    }

    @Override
    protected WebClientServiceResponse doProceed(WebClientServiceRequest serviceRequest, ClientRequestHeaders headers, Http2ClientStream stream) {
        Http2ClientStream.ClientOutputStream outputStream;
        ClientUri uri = serviceRequest.uri();
        Http2Headers http2Headers = this.prepareHeaders(serviceRequest.method(), headers, uri);
        stream.write(http2Headers, false);
        this.whenSent.complete(serviceRequest);
        try {
            outputStream = stream.outputStream();
            this.streamHandler.handle((OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!outputStream.closed()) {
            throw new IllegalStateException("Output stream was not closed in handler");
        }
        return this.readResponse(serviceRequest, stream);
    }
}

