/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.HeaderValues;
import io.helidon.http.WritableHeaders;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.ReleasableResource;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.UnixDomainSocketClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webclient.http1.Http1ClientImpl;
import io.helidon.webclient.spi.ClientConnectionCache;
import io.helidon.webclient.spi.DnsResolver;
import java.net.UnixDomainSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;

class Http1ConnectionCache
extends ClientConnectionCache {
    private static final System.Logger LOGGER = System.getLogger(Http1ConnectionCache.class.getName());
    private static final Tls NO_TLS = ((TlsConfig.Builder)Tls.builder().enabled(false)).build();
    private static final String HTTPS = "https";
    private static final Http1ConnectionCache SHARED = new Http1ConnectionCache(true);
    private static final List<String> ALPN_ID = List.of("http/1.1");
    private final Map<ConnectionKey, LinkedBlockingDeque<ClientConnection>> cache = new ConcurrentHashMap<ConnectionKey, LinkedBlockingDeque<ClientConnection>>();
    private final AtomicBoolean closed = new AtomicBoolean();

    protected Http1ConnectionCache(boolean shared) {
        super(shared);
    }

    static Http1ConnectionCache shared() {
        return SHARED;
    }

    static Http1ConnectionCache create() {
        return new Http1ConnectionCache(false);
    }

    ClientConnection connection(Http1ClientImpl http1Client, Tls tls, ClientUri uri, ClientRequestHeaders headers, boolean defaultKeepAlive, UnixDomainSocketAddress address) {
        Tls effectiveTls;
        boolean keepAlive = this.handleKeepAlive(defaultKeepAlive, (WritableHeaders<?>)headers);
        Tls tls2 = effectiveTls = HTTPS.equals(uri.scheme()) ? tls : NO_TLS;
        if (keepAlive) {
            return this.keepAliveUnixDomainConnection(http1Client, effectiveTls, uri, address);
        }
        return UnixDomainSocketClientConnection.create((WebClient)http1Client.webClient(), (Tls)effectiveTls, ALPN_ID, (UnixDomainSocketAddress)address, it -> false, it -> {});
    }

    ClientConnection connection(Http1ClientImpl http1Client, Tls tls, Proxy proxy, ClientUri uri, ClientRequestHeaders headers, boolean defaultKeepAlive) {
        Tls effectiveTls;
        boolean keepAlive = this.handleKeepAlive(defaultKeepAlive, (WritableHeaders<?>)headers);
        Tls tls2 = effectiveTls = HTTPS.equals(uri.scheme()) ? tls : NO_TLS;
        if (keepAlive) {
            return this.keepAliveConnection(http1Client, effectiveTls, uri, proxy);
        }
        return this.oneOffConnection(http1Client, effectiveTls, uri, proxy);
    }

    public void evict() {
        this.cache.values().stream().flatMap(Collection::stream).forEach(ReleasableResource::closeResource);
    }

    public void closeResource() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.evict();
    }

    private boolean handleKeepAlive(boolean defaultKeepAlive, WritableHeaders<?> headers) {
        if (headers.contains(HeaderValues.CONNECTION_CLOSE)) {
            return false;
        }
        if (defaultKeepAlive) {
            headers.setIfAbsent(HeaderValues.CONNECTION_KEEP_ALIVE);
            return true;
        }
        if (headers.contains(HeaderValues.CONNECTION_KEEP_ALIVE)) {
            return true;
        }
        headers.set(HeaderValues.CONNECTION_CLOSE);
        return false;
    }

    private ClientConnection keepAliveUnixDomainConnection(Http1ClientImpl http1Client, Tls tls, ClientUri uri, UnixDomainSocketAddress address) {
        ClientConnection connection;
        if (this.closed.get()) {
            throw new IllegalStateException("Connection cache is closed");
        }
        Http1ClientConfig clientConfig = http1Client.clientConfig();
        ConnectionKey connectionKey = ConnectionKey.create((String)uri.scheme(), (String)("unix:" + address.getPath().toString()), (int)0, (Tls)tls, (DnsResolver)clientConfig.dnsResolver(), (DnsAddressLookup)clientConfig.dnsAddressLookup(), (Proxy)Proxy.noProxy());
        LinkedBlockingDeque connectionQueue = this.cache.computeIfAbsent(connectionKey, it -> new LinkedBlockingDeque(clientConfig.connectionCacheSize()));
        while ((connection = (ClientConnection)connectionQueue.poll()) != null && !connection.isConnected()) {
        }
        if (connection == null) {
            connection = UnixDomainSocketClientConnection.create((WebClient)http1Client.webClient(), (Tls)tls, ALPN_ID, (UnixDomainSocketAddress)address, conn -> this.finishRequest(connectionQueue, (ClientConnection)conn), conn -> {}).connect();
        } else if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, String.format("[%s] UNIX socket client connection obtained %s", connection.channelId(), Thread.currentThread().getName()));
        }
        return connection;
    }

    private ClientConnection keepAliveConnection(Http1ClientImpl http1Client, Tls tls, ClientUri uri, Proxy proxy) {
        ClientConnection connection;
        if (this.closed.get()) {
            throw new IllegalStateException("Connection cache is closed");
        }
        Http1ClientConfig clientConfig = http1Client.clientConfig();
        ConnectionKey connectionKey = ConnectionKey.create((String)uri.scheme(), (String)uri.host(), (int)uri.port(), (Tls)tls, (DnsResolver)clientConfig.dnsResolver(), (DnsAddressLookup)clientConfig.dnsAddressLookup(), (Proxy)proxy);
        Queue connectionQueue = this.cache.computeIfAbsent(connectionKey, it -> new LinkedBlockingDeque(clientConfig.connectionCacheSize()));
        while ((connection = (ClientConnection)connectionQueue.poll()) != null && !connection.isConnected()) {
        }
        if (connection == null) {
            connection = TcpClientConnection.create((WebClient)http1Client.webClient(), (ConnectionKey)connectionKey, ALPN_ID, conn -> this.finishRequest(connectionQueue, (ClientConnection)conn), conn -> {}).connect();
        } else if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, String.format("[%s] client connection obtained %s", connection.channelId(), Thread.currentThread().getName()));
        }
        return connection;
    }

    private ClientConnection oneOffConnection(Http1ClientImpl http1Client, Tls tls, ClientUri uri, Proxy proxy) {
        WebClient webClient = http1Client.webClient();
        Http1ClientConfig clientConfig = http1Client.clientConfig();
        return TcpClientConnection.create((WebClient)webClient, (ConnectionKey)ConnectionKey.create((String)uri.scheme(), (String)uri.host(), (int)uri.port(), (Tls)tls, (DnsResolver)clientConfig.dnsResolver(), (DnsAddressLookup)clientConfig.dnsAddressLookup(), (Proxy)proxy), ALPN_ID, conn -> false, conn -> {}).connect();
    }

    private boolean finishRequest(Queue<ClientConnection> connectionQueue, ClientConnection conn) {
        if (conn.isConnected()) {
            conn.helidonSocket().idle();
            if (connectionQueue.offer(conn)) {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, String.format("[%s] client connection returned %s", conn.channelId(), Thread.currentThread().getName()));
                }
                return true;
            }
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format("[%s] Unable to return client connection because queue is full %s", conn.channelId(), Thread.currentThread().getName()));
            }
        }
        return false;
    }
}

