/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.GenericType;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.media.type.ParserMode;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.ClientResponseTrailers;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.Http1HeadersParser;
import io.helidon.http.Status;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.ReadableEntity;
import io.helidon.http.media.ReadableEntityBase;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientResponseEntity;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webclient.spi.Source;
import io.helidon.webclient.spi.SourceHandlerProvider;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

class Http1ClientResponseImpl
implements Http1ClientResponse {
    private static final System.Logger LOGGER = System.getLogger(Http1ClientResponseImpl.class.getName());
    private static final List<SourceHandlerProvider> SOURCE_HANDLERS = HelidonServiceLoader.builder(ServiceLoader.load(SourceHandlerProvider.class)).build().asList();
    private static final long ENTITY_LENGTH_CHUNKED = -1L;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HttpClientConfig clientConfig;
    private final Status responseStatus;
    private final ClientRequestHeaders requestHeaders;
    private final ClientResponseHeaders responseHeaders;
    private final InputStream inputStream;
    private final MediaContext mediaContext;
    private final CompletableFuture<Void> whenComplete;
    private final boolean hasTrailers;
    private final List<String> trailerNames;
    private final ParserMode parserMode;
    private final ClientUri lastEndpointUri;
    private final ClientConnection connection;
    private final CompletableFuture<Headers> trailers = new CompletableFuture();
    private boolean entityRequested;
    private long entityLength;

    Http1ClientResponseImpl(HttpClientConfig clientConfig, Status responseStatus, ClientRequestHeaders requestHeaders, ClientResponseHeaders responseHeaders, ClientConnection connection, InputStream inputStream, MediaContext mediaContext, ParserMode parserMode, ClientUri lastEndpointUri, CompletableFuture<Void> whenComplete) {
        this.clientConfig = clientConfig;
        this.responseStatus = responseStatus;
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
        this.connection = connection;
        this.inputStream = inputStream;
        this.mediaContext = mediaContext;
        this.parserMode = parserMode;
        this.lastEndpointUri = lastEndpointUri;
        this.whenComplete = whenComplete;
        if (responseHeaders.contains(HeaderNames.CONTENT_LENGTH)) {
            this.entityLength = Long.parseLong(responseHeaders.get(HeaderNames.CONTENT_LENGTH).value());
        } else if (responseHeaders.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED)) {
            this.entityLength = -1L;
        }
        if (responseHeaders.contains(HeaderNames.TRAILER)) {
            this.hasTrailers = true;
            this.trailerNames = responseHeaders.get(HeaderNames.TRAILER).allValues(true);
        } else {
            this.hasTrailers = false;
            this.trailerNames = List.of();
        }
    }

    public Status status() {
        return this.responseStatus;
    }

    public ClientResponseHeaders headers() {
        return this.responseHeaders;
    }

    public ClientResponseTrailers trailers() {
        if (this.hasTrailers) {
            Duration timeout = this.clientConfig.readTimeout().orElseGet(() -> this.clientConfig.socketOptions().readTimeout());
            if (!this.entityRequested) {
                throw new IllegalStateException("Trailers requested before reading entity.");
            }
            try {
                return ClientResponseTrailers.create((Headers)this.trailers.get(timeout.toMillis(), TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Timeout " + String.valueOf(timeout) + " reached while waiting for trailers.", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while waiting for trailers.", e);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof IllegalStateException) {
                    IllegalStateException ise = (IllegalStateException)throwable;
                    throw ise;
                }
                throw new IllegalStateException(e.getCause());
            }
        }
        return ClientResponseTrailers.create();
    }

    public ReadableEntity entity() {
        this.entityRequested = true;
        return this.entity(this.requestHeaders, this.responseHeaders);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (this.headers().contains(HeaderValues.CONNECTION_CLOSE)) {
                    this.connection.closeResource();
                } else if (this.entityLength == 0L) {
                    this.connection.releaseResource();
                } else if (this.entityLength == -1L) {
                    if (this.hasTrailers) {
                        this.readTrailers();
                        this.connection.releaseResource();
                    } else {
                        this.connection.closeResource();
                    }
                } else {
                    this.connection.closeResource();
                }
            }
            finally {
                this.whenComplete.complete(null);
            }
        }
    }

    public <T extends Source<?>> void source(GenericType<T> sourceType, T source) {
        for (SourceHandlerProvider p : SOURCE_HANDLERS) {
            if (!p.supports(sourceType, (HttpClientResponse)this)) continue;
            p.handle(source, (HttpClientResponse)this, this.mediaContext);
            return;
        }
        throw new UnsupportedOperationException("No source available for " + String.valueOf(sourceType));
    }

    public ClientUri lastEndpointUri() {
        return this.lastEndpointUri;
    }

    ClientConnection connection() {
        return this.connection;
    }

    private ReadableEntity entity(ClientRequestHeaders requestHeaders, ClientResponseHeaders responseHeaders) {
        if (this.inputStream == null) {
            return ReadableEntityBase.empty();
        }
        return ClientResponseEntity.create(this::readBytes, this::close, (ClientRequestHeaders)requestHeaders, (ClientResponseHeaders)responseHeaders, (MediaContext)this.mediaContext);
    }

    private void readTrailers() {
        this.trailers.complete((Headers)Http1HeadersParser.readHeaders((DataReader)this.connection.reader(), (int)1024, (boolean)true));
    }

    private BufferData readBytes(int estimate) {
        BufferData bufferData = BufferData.create((int)estimate);
        int bytesRead = bufferData.readFrom(this.inputStream);
        if (bytesRead == -1) {
            return null;
        }
        return bufferData;
    }
}

