/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.uri.UriQueryWriteable;
import io.helidon.http.Headers;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.FullClientRequest;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webclient.http1.Http1ClientProtocolConfig;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientRequestImpl;
import io.helidon.webclient.http1.Http1ConnectionCache;
import io.helidon.webclient.spi.HttpClientSpi;
import java.util.Map;

class Http1ClientImpl
implements Http1Client,
HttpClientSpi {
    private final WebClient webClient;
    private final Http1ClientConfig clientConfig;
    private final Http1ClientProtocolConfig protocolConfig;
    private final Http1ConnectionCache connectionCache;

    Http1ClientImpl(WebClient webClient, Http1ClientConfig clientConfig) {
        this.webClient = webClient;
        this.clientConfig = clientConfig;
        this.protocolConfig = clientConfig.protocolConfig();
        this.connectionCache = clientConfig.shareConnectionCache() ? Http1ConnectionCache.shared() : Http1ConnectionCache.create();
    }

    public Http1ClientRequest method(Method method) {
        ClientUri clientUri = this.clientConfig.baseUri().map(ClientUri::create).orElseGet(ClientUri::create);
        this.clientConfig.baseFragment().ifPresent(arg_0 -> ((ClientUri)clientUri).fragment(arg_0));
        this.clientConfig.baseQuery().ifPresent(arg_0 -> ((UriQueryWriteable)clientUri.writeableQuery()).from(arg_0));
        return new Http1ClientRequestImpl(this, method, clientUri, (Map<String, String>)this.clientConfig.properties());
    }

    public Http1ClientConfig prototype() {
        return this.clientConfig;
    }

    public HttpClientSpi.SupportLevel supports(FullClientRequest<?> clientRequest, ClientUri clientUri) {
        return HttpClientSpi.SupportLevel.COMPATIBLE;
    }

    public ClientRequest<?> clientRequest(FullClientRequest<?> clientRequest, ClientUri clientUri) {
        Http1ClientRequestImpl request = new Http1ClientRequestImpl(this, clientRequest.method(), clientUri, (Map<String, String>)clientRequest.properties());
        clientRequest.connection().ifPresent(arg_0 -> ((Http1ClientRequest)request).connection(arg_0));
        clientRequest.pathParams().forEach((arg_0, arg_1) -> ((Http1ClientRequest)request).pathParam(arg_0, arg_1));
        return ((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)request.readTimeout(clientRequest.readTimeout())).followRedirects(clientRequest.followRedirects())).maxRedirects(clientRequest.maxRedirects())).keepAlive(clientRequest.keepAlive())).proxy(clientRequest.proxy())).tls(clientRequest.tls())).headers((Headers)clientRequest.headers())).fragment(clientUri.fragment());
    }

    WebClient webClient() {
        return this.webClient;
    }

    Http1ClientConfig clientConfig() {
        return this.clientConfig;
    }

    Http1ClientProtocolConfig protocolConfig() {
        return this.protocolConfig;
    }

    Http1ConnectionCache connectionCache() {
        return this.connectionCache;
    }
}

