/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.GenericType;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Http;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.InstanceWriter;
import io.helidon.http.media.MediaContext;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientRequestBase;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http1.Http1CallChainBase;
import io.helidon.webclient.http1.Http1CallEntityChain;
import io.helidon.webclient.http1.Http1CallOutputStreamChain;
import io.helidon.webclient.http1.Http1ClientImpl;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webclient.http1.Http1ClientResponseImpl;
import io.helidon.webclient.http1.RedirectionProcessor;
import io.helidon.webclient.http1.UpgradeResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

class Http1ClientRequestImpl
extends ClientRequestBase<Http1ClientRequest, Http1ClientResponse>
implements Http1ClientRequest {
    private static final System.Logger LOGGER = System.getLogger(Http1ClientRequestImpl.class.getName());
    private final Http1ClientImpl http1Client;

    Http1ClientRequestImpl(Http1ClientImpl http1Client, Http.Method method, ClientUri clientUri, Map<String, String> properties) {
        super((HttpClientConfig)http1Client.clientConfig(), http1Client.webClient().cookieManager(), "http/1.1", method, clientUri, properties);
        this.http1Client = http1Client;
    }

    Http1ClientRequestImpl(Http1ClientRequestImpl request, Http.Method method, ClientUri clientUri, Map<String, String> properties) {
        this(request.http1Client, method, clientUri, properties);
        this.followRedirects(request.followRedirects());
        this.maxRedirects(request.maxRedirects());
        this.tls(request.tls());
    }

    public Http1ClientResponse doSubmit(Object entity) {
        byte[] entityBytes;
        if (entity == BufferData.EMPTY_BYTES) {
            entityBytes = BufferData.EMPTY_BYTES;
        } else if (entity instanceof byte[]) {
            byte[] buffer = (byte[])entity;
            entityBytes = buffer;
        } else {
            GenericType genericType = GenericType.create((Object)entity);
            EntityWriter mediaWriter = this.clientConfig().mediaContext().writer(genericType, (WritableHeaders)this.headers());
            long configuredContentLength = this.headers().contentLength().orElse(-1L);
            if (mediaWriter.supportsInstanceWriter()) {
                InstanceWriter instanceWriter = mediaWriter.instanceWriter(genericType, entity, (WritableHeaders)this.headers());
                if (instanceWriter.alwaysInMemory()) {
                    entityBytes = instanceWriter.instanceBytes();
                } else {
                    long length = instanceWriter.contentLength().orElse(configuredContentLength);
                    if (length == -1L) {
                        return this.doOutputStream(arg_0 -> ((InstanceWriter)instanceWriter).write(arg_0));
                    }
                    if (length > (long)this.clientConfig().maxInMemoryEntity()) {
                        this.headers().contentLength(length);
                        return this.doOutputStream(arg_0 -> ((InstanceWriter)instanceWriter).write(arg_0));
                    }
                    entityBytes = instanceWriter.instanceBytes();
                }
            } else {
                if (configuredContentLength == -1L || configuredContentLength > (long)this.clientConfig().maxInMemoryEntity()) {
                    return this.doOutputStream(it -> mediaWriter.write(genericType, entity, it, (WritableHeaders)this.headers()));
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)configuredContentLength);
                mediaWriter.write(genericType, entity, (OutputStream)baos, (WritableHeaders)this.headers());
                entityBytes = baos.toByteArray();
            }
        }
        if (this.followRedirects()) {
            return RedirectionProcessor.invokeWithFollowRedirects(this, entityBytes);
        }
        return this.invokeRequestWithEntity(entityBytes);
    }

    public Http1ClientResponse doOutputStream(ClientRequest.OutputStreamHandler streamHandler) {
        CompletableFuture<WebClientServiceRequest> whenSent = new CompletableFuture<WebClientServiceRequest>();
        CompletableFuture<WebClientServiceResponse> whenComplete = new CompletableFuture<WebClientServiceResponse>();
        Http1CallOutputStreamChain callChain = new Http1CallOutputStreamChain(this.http1Client, this, whenSent, whenComplete, streamHandler);
        return this.invokeWithServices(callChain, whenSent, whenComplete);
    }

    @Override
    public UpgradeResponse upgrade(String protocol) {
        if (!this.headers().contains(Http.HeaderNames.UPGRADE)) {
            this.headers().set(Http.HeaderNames.UPGRADE, new String[]{protocol});
        }
        Http.Header requestedUpgrade = this.headers().get(Http.HeaderNames.UPGRADE);
        Http1ClientResponseImpl response = this.followRedirects() ? RedirectionProcessor.invokeWithFollowRedirects(this, BufferData.EMPTY_BYTES) : this.invokeRequestWithEntity(BufferData.EMPTY_BYTES);
        if (response.status() == Http.Status.SWITCHING_PROTOCOLS_101) {
            if (response.headers().contains(requestedUpgrade)) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    response.connection().helidonSocket().log(LOGGER, System.Logger.Level.TRACE, "Upgrading to %s", new Object[]{requestedUpgrade});
                }
                return UpgradeResponse.success(response, response.connection());
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                response.connection().helidonSocket().log(LOGGER, System.Logger.Level.TRACE, "Upgrade failed. Expected upgrade: {0}, got headers: {1}", new Object[]{requestedUpgrade, response.headers()});
            }
        } else if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            response.connection().helidonSocket().log(LOGGER, System.Logger.Level.TRACE, "Upgrade failed. Tried upgrading to %s, got status: %s", new Object[]{requestedUpgrade, response.status()});
        }
        return UpgradeResponse.failure(response);
    }

    protected MediaContext mediaContext() {
        return super.mediaContext();
    }

    Http1ClientImpl http1Client() {
        return this.http1Client;
    }

    Http1ClientResponseImpl invokeRequestWithEntity(byte[] entity) {
        CompletableFuture<WebClientServiceRequest> whenSent = new CompletableFuture<WebClientServiceRequest>();
        CompletableFuture<WebClientServiceResponse> whenComplete = new CompletableFuture<WebClientServiceResponse>();
        Http1CallEntityChain callChain = new Http1CallEntityChain(this.http1Client, this, whenSent, whenComplete, entity);
        return this.invokeWithServices(callChain, whenSent, whenComplete);
    }

    private Http1ClientResponseImpl invokeWithServices(Http1CallChainBase callChain, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete) {
        ClientUri resolvedUri = this.resolvedUri();
        WebClientServiceResponse serviceResponse = this.invokeServices(callChain, whenSent, whenComplete, resolvedUri);
        CompletableFuture<Void> complete = new CompletableFuture<Void>();
        ((CompletableFuture)complete.thenAccept(ignored -> serviceResponse.whenComplete().complete(serviceResponse))).exceptionally(throwable -> {
            serviceResponse.whenComplete().completeExceptionally((Throwable)throwable);
            return null;
        });
        return new Http1ClientResponseImpl(this.clientConfig(), serviceResponse.status(), serviceResponse.serviceRequest().headers(), serviceResponse.headers(), callChain.connection(), serviceResponse.inputStream().orElse(null), this.mediaContext(), this.clientConfig().mediaTypeParserMode(), resolvedUri, complete);
    }
}

