/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.webclient.grpc.GrpcBaseClientCall;
import io.helidon.webclient.grpc.GrpcChannel;
import io.helidon.webclient.http2.StreamTimeoutException;

class GrpcUnaryClientCall<ReqT, ResT>
extends GrpcBaseClientCall<ReqT, ResT> {
    private static final System.Logger LOGGER = System.getLogger(GrpcUnaryClientCall.class.getName());
    private volatile boolean closeCalled;
    private volatile boolean requestSent;
    private volatile boolean responseSent;

    GrpcUnaryClientCall(GrpcChannel grpcChannel, MethodDescriptor<ReqT, ResT> methodDescriptor, CallOptions callOptions) {
        super(grpcChannel, methodDescriptor, callOptions);
    }

    public void request(int numMessages) {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "request called %d", new Object[]{numMessages});
        if (numMessages < 1) {
            this.close(Status.INVALID_ARGUMENT);
        }
    }

    public void cancel(String message, Throwable cause) {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "cancel called %s", new Object[]{message});
        this.close(Status.CANCELLED);
    }

    public void halfClose() {
        this.socket().log(LOGGER, System.Logger.Level.DEBUG, "halfClose called", new Object[0]);
        this.close(this.responseSent ? Status.OK : Status.UNKNOWN);
    }

    public void sendMessage(ReqT message) {
        if (this.requestSent) {
            this.close(Status.FAILED_PRECONDITION);
            return;
        }
        byte[] serialized = this.serializeMessage(message);
        BufferData messageData = BufferData.createReadOnly((byte[])serialized, (int)0, (int)serialized.length);
        BufferData headerData = BufferData.create((int)5);
        headerData.writeInt8(0);
        headerData.writeUnsignedInt32((long)messageData.available());
        this.clientStream().writeData(BufferData.create((BufferData[])new BufferData[]{headerData, messageData}), true);
        this.requestSent = true;
        this.clientStream().readHeaders();
        while (this.isRemoteOpen()) {
            Http2FrameData frameData;
            if (this.clientStream().trailers().isDone() || !this.clientStream().hasEntity()) {
                this.socket().log(LOGGER, System.Logger.Level.DEBUG, "[Reading thread] trailers or eos received", new Object[0]);
                break;
            }
            try {
                frameData = this.clientStream().readOne(this.pollWaitTime());
            }
            catch (StreamTimeoutException e) {
                if (this.abortPollTimeExpired()) {
                    this.socket().log(LOGGER, System.Logger.Level.ERROR, "[Reading thread] HTTP/2 stream timeout, aborting", new Object[0]);
                    this.responseListener().onClose(Status.DEADLINE_EXCEEDED, EMPTY_METADATA);
                    break;
                }
                this.socket().log(LOGGER, System.Logger.Level.ERROR, "[Reading thread] HTTP/2 stream timeout, retrying", new Object[0]);
                continue;
            }
            if (frameData == null) continue;
            this.socket().log(LOGGER, System.Logger.Level.DEBUG, "response received", new Object[0]);
            this.responseListener().onMessage(this.toResponse(frameData.data()));
            this.responseSent = true;
        }
    }

    @Override
    protected void startStreamingThreads() {
    }

    private void close(Status status) {
        if (!this.closeCalled) {
            this.socket().log(LOGGER, System.Logger.Level.DEBUG, "closing client call", new Object[0]);
            this.responseListener().onClose(status, EMPTY_METADATA);
            this.clientStream().cancel();
            this.connection().close();
            this.unblockUnaryExecutor();
            this.closeCalled = true;
        }
    }
}

