/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.tls.Tls;
import io.helidon.common.uri.UriEncoding;
import io.helidon.common.uri.UriFragment;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.Method;
import io.helidon.http.media.MediaContext;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.FullClientRequest;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.ServiceChainImpl;
import io.helidon.webclient.api.ServiceRequestImpl;
import io.helidon.webclient.api.WebClientCookieManager;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.spi.WebClientService;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public abstract class ClientRequestBase<T extends ClientRequest<T>, R extends HttpClientResponse>
implements FullClientRequest<T> {
    public static final Header USER_AGENT_HEADER = HeaderValues.create((HeaderName)HeaderNames.USER_AGENT, (String)"Helidon 4.3.0-M3");
    public static final Header PROXY_CONNECTION = HeaderValues.create((String)"Proxy-Connection", (String)"keep-alive");
    private static final Map<String, AtomicLong> COUNTERS = new ConcurrentHashMap<String, AtomicLong>();
    private static final Set<String> SUPPORTED_SCHEMES = Set.of("https", "http");
    private final Map<String, String> pathParams = new HashMap<String, String>();
    private final HttpClientConfig clientConfig;
    private final WebClientCookieManager cookieManager;
    private final String protocolId;
    private final Method method;
    private final ClientUri clientUri;
    private final Map<String, String> properties;
    private final ClientRequestHeaders headers;
    private final String requestId;
    private final MediaContext mediaContext;
    private String uriTemplate;
    private boolean skipUriEncoding;
    private boolean followRedirects;
    private int maxRedirects;
    private Duration readTimeout;
    private Duration readContinueTimeout;
    private Tls tls;
    private Proxy proxy;
    private boolean keepAlive;
    private ClientConnection connection;
    private Boolean sendExpectContinue;

    protected ClientRequestBase(HttpClientConfig clientConfig, WebClientCookieManager cookieManager, String protocolId, Method method, ClientUri clientUri, Map<String, String> properties) {
        this(clientConfig, cookieManager, protocolId, method, clientUri, null, properties);
    }

    protected ClientRequestBase(HttpClientConfig clientConfig, WebClientCookieManager cookieManager, String protocolId, Method method, ClientUri clientUri, Boolean sendExpectContinue, Map<String, String> properties) {
        this.clientConfig = clientConfig;
        this.cookieManager = cookieManager;
        this.protocolId = protocolId;
        this.method = method;
        this.clientUri = clientUri;
        this.sendExpectContinue = sendExpectContinue;
        this.properties = new HashMap<String, String>(properties);
        this.headers = clientConfig.defaultRequestHeaders();
        this.readTimeout = clientConfig.socketOptions().readTimeout();
        this.readContinueTimeout = clientConfig.readContinueTimeout();
        this.mediaContext = clientConfig.mediaContext();
        this.followRedirects = clientConfig.followRedirects();
        this.maxRedirects = clientConfig.maxRedirects();
        this.tls = clientConfig.tls();
        this.proxy = clientConfig.proxy();
        this.keepAlive = clientConfig.keepAlive();
        this.requestId = ClientRequestBase.nextRequestId(protocolId);
    }

    @Override
    public T tls(Tls tls) {
        this.tls = tls;
        return this.identity();
    }

    @Override
    public T uri(URI uri) {
        this.uriTemplate = null;
        this.clientUri.resolve(uri);
        return this.identity();
    }

    @Override
    public T uri(ClientUri uri) {
        this.uriTemplate = null;
        this.clientUri.resolve(uri);
        return this.identity();
    }

    @Override
    public T path(String uri) {
        this.clientUri.resolvePath(uri);
        return this.identity();
    }

    @Override
    public T uri(String uri) {
        if (uri.indexOf(123) > -1) {
            this.uriTemplate = uri;
        } else {
            this.uri(URI.create(UriEncoding.encodeUri((String)uri)));
        }
        return this.identity();
    }

    @Override
    public ClientUri resolvedUri() {
        return this.resolveUri(ClientUri.create(this.clientUri));
    }

    @Override
    public ClientRequestHeaders headers() {
        return this.headers;
    }

    @Override
    public T header(Header header) {
        this.headers.set(header);
        return this.identity();
    }

    @Override
    public T headers(Headers headers) {
        for (Header header : headers) {
            this.headers.set(header);
        }
        return this.identity();
    }

    @Override
    public T headers(Consumer<ClientRequestHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this.identity();
    }

    @Override
    public T fragment(UriFragment fragment) {
        this.clientUri.fragment(fragment);
        return this.identity();
    }

    @Override
    public T skipUriEncoding(boolean skip) {
        this.skipUriEncoding = skip;
        this.clientUri.skipUriEncoding(skip);
        return this.identity();
    }

    @Override
    public T queryParam(String name, String ... values) {
        this.clientUri.writeableQuery().set(name, values);
        return this.identity();
    }

    @Override
    public T property(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this.identity();
    }

    @Override
    public T pathParam(String name, String value) {
        this.pathParams.put(name, value);
        return this.identity();
    }

    @Override
    public T followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this.identity();
    }

    @Override
    public T maxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this.identity();
    }

    @Override
    public T connection(ClientConnection connection) {
        this.connection = connection;
        return this.identity();
    }

    @Override
    public T keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this.identity();
    }

    @Override
    public T readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this.identity();
    }

    @Override
    public T readContinueTimeout(Duration readContinueTimeout) {
        this.readContinueTimeout = readContinueTimeout;
        return this.identity();
    }

    @Override
    public T proxy(Proxy proxy) {
        this.proxy = Objects.requireNonNull(proxy);
        return this.identity();
    }

    public R request() {
        this.additionalHeaders();
        return this.validateAndSubmit(BufferData.EMPTY_BYTES);
    }

    public R submit(Object entity) {
        byte[] bytes;
        if (!(entity instanceof byte[]) || (bytes = (byte[])entity).length != 0) {
            this.rejectHeadWithEntity();
        }
        this.additionalHeaders();
        return this.validateAndSubmit(entity);
    }

    public R outputStream(ClientRequest.OutputStreamHandler outputStreamConsumer) {
        this.rejectHeadWithEntity();
        this.additionalHeaders();
        return this.doOutputStream(outputStreamConsumer);
    }

    @Override
    public T sendExpectContinue(boolean sendExpectContinue) {
        this.sendExpectContinue = sendExpectContinue;
        return this.identity();
    }

    protected void additionalHeaders() {
        this.headers.setIfAbsent(USER_AGENT_HEADER);
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public boolean followRedirects() {
        return this.followRedirects;
    }

    @Override
    public int maxRedirects() {
        return this.maxRedirects;
    }

    @Override
    public Tls tls() {
        return this.tls;
    }

    @Override
    public Proxy proxy() {
        return this.proxy;
    }

    @Override
    public Optional<ClientConnection> connection() {
        return Optional.ofNullable(this.connection);
    }

    @Override
    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    @Override
    public ClientUri uri() {
        return this.clientUri;
    }

    @Override
    public String requestId() {
        return this.requestId;
    }

    @Override
    public Duration readTimeout() {
        return this.readTimeout;
    }

    @Override
    public Duration readContinueTimeout() {
        return this.readContinueTimeout;
    }

    @Override
    public boolean keepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean skipUriEncoding() {
        return this.skipUriEncoding;
    }

    @Override
    public Optional<Boolean> sendExpectContinue() {
        return Optional.ofNullable(this.sendExpectContinue);
    }

    protected abstract R doSubmit(Object var1);

    protected abstract R doOutputStream(ClientRequest.OutputStreamHandler var1);

    protected WebClientServiceResponse invokeServices(WebClientService.Chain httpCallChain, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete, ClientUri usedUri) {
        this.cookieManager.request(usedUri, this.headers);
        ServiceRequestImpl serviceRequest = new ServiceRequestImpl(usedUri, this.method, this.protocolId, this.headers, Contexts.context().orElseGet(Context::create), this.requestId, whenComplete, whenSent, this.properties);
        WebClientService.Chain last = httpCallChain;
        List<WebClientService> services = this.clientConfig.services();
        ListIterator<WebClientService> serviceIterator = services.listIterator(services.size());
        while (serviceIterator.hasPrevious()) {
            last = new ServiceChainImpl(last, serviceIterator.previous());
        }
        WebClientServiceResponse response = last.proceed(serviceRequest);
        this.cookieManager.response(usedUri, response.headers());
        return response;
    }

    protected HttpClientConfig clientConfig() {
        return this.clientConfig;
    }

    protected MediaContext mediaContext() {
        return this.mediaContext;
    }

    protected ClientUri resolveUri(ClientUri toResolve) {
        if (this.uriTemplate != null) {
            String resolved = this.resolvePathParams(this.uriTemplate);
            if (this.skipUriEncoding) {
                toResolve.resolve(URI.create(resolved));
            } else {
                toResolve.resolve(URI.create(UriEncoding.encodeUri((String)resolved)));
            }
        }
        return toResolve;
    }

    private static String nextRequestId(String protocolId) {
        AtomicLong counter = COUNTERS.computeIfAbsent(protocolId, it -> new AtomicLong());
        return "client-" + protocolId + "-" + Long.toHexString(counter.getAndIncrement());
    }

    private R validateAndSubmit(Object entity) {
        if (!SUPPORTED_SCHEMES.contains(this.uri().scheme())) {
            throw new IllegalArgumentException(String.format("Not supported scheme %s, client supported schemes are: %s", this.uri().scheme(), String.join((CharSequence)", ", SUPPORTED_SCHEMES)));
        }
        return this.doSubmit(entity);
    }

    private String resolvePathParams(String path) {
        String result = path;
        for (Map.Entry<String, String> entry : this.pathParams.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            result = result.replace("{" + name + "}", value);
        }
        if (result.contains("{")) {
            throw new IllegalArgumentException("Not all path parameters are defined. Template after resolving parameters: " + result);
        }
        return result;
    }

    private void rejectHeadWithEntity() {
        if (Method.HEAD.equals((Object)this.method)) {
            throw new IllegalArgumentException("Payload in method '" + String.valueOf(Method.HEAD) + "' has no defined semantics");
        }
    }

    private T identity() {
        return (T)this;
    }
}

