/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.testing.junit5;

import io.helidon.common.Functions;
import io.helidon.common.GenericType;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.logging.common.LogConfig;
import io.helidon.service.registry.GlobalServiceRegistry;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.ServiceRegistryManager;
import io.helidon.testing.TestException;
import io.helidon.testing.TestRegistry;
import io.helidon.testing.junit5.Testing;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.DynamicTestInvocationContext;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class TestJunitExtension
implements Extension,
InvocationInterceptor,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestJunitExtension.class});

    protected TestJunitExtension() {
    }

    protected static <T> Optional<T> storeLookup(ExtensionContext.Store store, Object key, Class<T> type) {
        return Optional.ofNullable(store.get(key, type));
    }

    protected static ExtensionContext.Store store(ExtensionContext ctx, AnnotatedElement ... qualifiers) {
        ExtensionContext.Namespace ns = qualifiers.length > 0 ? NAMESPACE.append(Arrays.stream(qualifiers).map(e -> {
            AnnotatedElement annotatedElement = e;
            Objects.requireNonNull(annotatedElement);
            AnnotatedElement selector0$temp = annotatedElement;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Method.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Class c = (Class)selector0$temp;
                    yield c.getName();
                }
                case 1 -> {
                    Method m = (Method)selector0$temp;
                    yield m.getName();
                }
                default -> throw new IllegalArgumentException("Unsupported element: " + String.valueOf(e));
            };
        }).toArray()) : NAMESPACE;
        return ctx.getStore(ns);
    }

    public void beforeAll(ExtensionContext ctx) {
        ExtensionContext.Store store = TestJunitExtension.store(ctx, ctx.getRequiredTestClass());
        this.initStaticContext(store, ctx);
        this.run(ctx, LogConfig::configureRuntime);
    }

    public void afterAll(ExtensionContext context) {
        this.run(context, () -> this.afterShutdownMethods(context.getRequiredTestClass()));
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        TestContext testContext = this.ourTestContext(extensionContext).orElseThrow();
        String methodName = extensionContext.getRequiredTestMethod().getName();
        testContext.beforeMethod(methodName);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        TestContext testContext = this.ourTestContext(extensionContext).orElseThrow();
        testContext.afterMethod();
    }

    public boolean supportsParameter(ParameterContext pc, ExtensionContext ctx) throws ParameterResolutionException {
        return (Boolean)this.supplyChecked(ctx, () -> {
            Class<?> paramType = pc.getParameter().getType();
            GenericType genericParamType = GenericType.create((Type)pc.getParameter().getParameterizedType());
            if (!genericParamType.isClass()) {
                return false;
            }
            return this.supportedType(GlobalServiceRegistry.registry(), paramType);
        });
    }

    public Object resolveParameter(ParameterContext pc, ExtensionContext ctx) throws ParameterResolutionException {
        return this.supplyChecked(ctx, () -> {
            Class<?> paramType = pc.getParameter().getType();
            ServiceRegistry registry = GlobalServiceRegistry.registry();
            if (this.supportedType(registry, paramType)) {
                return registry.get(paramType);
            }
            throw new ParameterResolutionException("Failed to resolve parameter of type " + paramType.getName());
        });
    }

    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> ic, ExtensionContext ctx) throws Throwable {
        return this.invoke(ctx, invocation);
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(ctx, invocation);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(ctx, invocation);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(ctx, invocation);
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        return this.invoke(ctx, invocation);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(ctx, invocation);
    }

    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, DynamicTestInvocationContext ic, ExtensionContext ctx) throws Throwable {
        this.invoke(ctx, invocation);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(ctx, invocation);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> ic, ExtensionContext ctx) throws Throwable {
        this.invoke(ctx, invocation);
    }

    protected void initStaticContext(ExtensionContext ctx) {
        this.initStaticContext(TestJunitExtension.store(ctx, ctx.getRequiredTestClass()), ctx);
    }

    protected void initStaticContext(ExtensionContext.Store store, ExtensionContext ctx) {
        store.getOrComputeIfAbsent(TestContext.class, c -> {
            Class testClass = ctx.getRequiredTestClass();
            Testing.Test annotation = testClass.getAnnotation(Testing.Test.class);
            boolean perMethod = annotation != null && annotation.perMethod();
            return perMethod ? PerMethodTestContext.create(testClass) : PerClassTestContext.create(testClass);
        });
    }

    protected Optional<Context> staticContext(ExtensionContext ctx) {
        return this.ourTestContext(ctx).map(TestContext::context);
    }

    protected <T> T supply(ExtensionContext ctx, Supplier<T> supplier) throws Throwable {
        return (T)Contexts.runInContext((Context)this.staticContext(ctx).orElseThrow(), supplier::get);
    }

    protected <T, E extends Throwable> T supplyChecked(ExtensionContext ctx, Functions.CheckedSupplier<T, E> supplier) throws E {
        AtomicReference thrown = new AtomicReference();
        Object response = Contexts.runInContext((Context)this.staticContext(ctx).orElseThrow(), () -> {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                thrown.set(e);
                return null;
            }
        });
        if (thrown.get() == null) {
            return (T)response;
        }
        Throwable throwable = (Throwable)thrown.get();
        if (throwable instanceof RuntimeException) {
            RuntimeException rte = (RuntimeException)throwable;
            throw rte;
        }
        if (throwable instanceof Error) {
            Error err = (Error)throwable;
            throw err;
        }
        throw throwable;
    }

    protected void run(ExtensionContext ctx, Runnable runnable) {
        Contexts.runInContext((Context)this.staticContext(ctx).orElseThrow(), (Runnable)runnable);
    }

    protected <E extends Throwable> void runChecked(ExtensionContext ctx, Functions.CheckedRunnable<E> runnable) throws E {
        AtomicReference thrown = new AtomicReference();
        Contexts.runInContext((Context)this.staticContext(ctx).orElseThrow(), () -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                thrown.set(e);
            }
        });
        if (thrown.get() == null) {
            return;
        }
        Throwable throwable = (Throwable)thrown.get();
        if (throwable instanceof RuntimeException) {
            RuntimeException rte = (RuntimeException)throwable;
            throw rte;
        }
        if (throwable instanceof Error) {
            Error err = (Error)throwable;
            throw err;
        }
        throw throwable;
    }

    protected <T> T invoke(ExtensionContext ctx, InvocationInterceptor.Invocation<T> invocation) throws Throwable {
        AtomicReference thrown = new AtomicReference();
        Object response = Contexts.runInContext((Context)this.staticContext(ctx).orElseThrow(), () -> {
            try {
                return invocation.proceed();
            }
            catch (Throwable e) {
                thrown.set(e);
                return null;
            }
        });
        if (thrown.get() != null) {
            throw (Throwable)thrown.get();
        }
        return (T)response;
    }

    private Optional<TestContext> ourTestContext(ExtensionContext ctx) {
        ExtensionContext.Store store = TestJunitExtension.store(ctx, ctx.getRequiredTestClass());
        return Optional.ofNullable((TestContext)store.get(TestContext.class, TestContext.class));
    }

    private void afterShutdownMethods(Class<?> requiredTestClass) {
        for (Method declaredMethod : requiredTestClass.getDeclaredMethods()) {
            TestRegistry.AfterShutdown annotation = declaredMethod.getAnnotation(TestRegistry.AfterShutdown.class);
            if (annotation == null) continue;
            if (!Modifier.isStatic(declaredMethod.getModifiers())) {
                throw new TestException("Cannot invoke @TestRegistry.AfterShutdown annotated method " + declaredMethod.getName() + ", as it is not static");
            }
            try {
                declaredMethod.setAccessible(true);
                declaredMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new TestException("Failed to invoke @TestRegistry.AfterShutdown annotated method " + declaredMethod.getName(), (Throwable)e);
            }
        }
    }

    private boolean supportedType(ServiceRegistry registry, Class<?> paramType) {
        if (ServiceRegistry.class.isAssignableFrom(paramType)) {
            return true;
        }
        return !registry.allServices(paramType).isEmpty();
    }

    static {
        LogConfig.initClass();
    }

    private static interface TestContext
    extends ExtensionContext.Store.CloseableResource {
        default public void close() {
        }

        public Context context();

        default public void beforeMethod(String methodName) {
        }

        default public void afterMethod() {
        }
    }

    private static class PerMethodTestContext
    implements TestContext {
        private final Class<?> testClass;
        private final Context testClassContext;
        private volatile Context context;
        private volatile ServiceRegistryManager manager;

        private PerMethodTestContext(Class<?> testClass, Context testClassContext) {
            this.testClass = testClass;
            this.testClassContext = testClassContext;
        }

        static TestContext create(Class<?> testClass) {
            Context testClassContext = Context.builder().id("test-" + testClass.getName() + "-" + System.identityHashCode(testClass)).build();
            testClassContext.register((Object)"helidon-registry-static-context", (Object)testClassContext);
            return new PerMethodTestContext(testClass, testClassContext);
        }

        @Override
        public Context context() {
            if (this.context == null) {
                return this.testClassContext;
            }
            return this.context;
        }

        @Override
        public void close() {
            if (this.manager != null) {
                this.manager.shutdown();
                this.context = null;
                this.manager = null;
            }
        }

        @Override
        public void beforeMethod(String methodName) {
            ServiceRegistryManager manager = ServiceRegistryManager.create();
            ServiceRegistry registry = manager.registry();
            Context context = Context.builder().id("test-" + this.testClass.getName() + "-" + System.identityHashCode(this.testClass) + "." + methodName).build();
            context.register((Object)"helidon-registry-static-context", (Object)context);
            context.register((Object)"helidon-registry", (Object)registry);
            this.testClassContext.register((Object)"helidon-registry-static-context", (Object)context);
            this.manager = manager;
            this.context = context;
        }

        @Override
        public void afterMethod() {
            this.testClassContext.register((Object)"helidon-registry-static-context", (Object)this.testClassContext);
            this.close();
        }
    }

    private static class PerClassTestContext
    implements TestContext {
        private final Context context;
        private final ServiceRegistryManager manager;

        private PerClassTestContext(Context context, ServiceRegistryManager manager) {
            this.context = context;
            this.manager = manager;
        }

        @Override
        public void close() {
            this.manager.shutdown();
        }

        @Override
        public Context context() {
            return this.context;
        }

        private static TestContext create(Class<?> testClass) {
            ServiceRegistryManager manager = ServiceRegistryManager.create();
            ServiceRegistry registry = manager.registry();
            Context context = Context.builder().id("test-" + testClass.getName() + "-" + System.identityHashCode(testClass)).build();
            context.register((Object)"helidon-registry-static-context", (Object)context);
            context.register((Object)"helidon-registry", (Object)registry);
            return new PerClassTestContext(context, manager);
        }
    }
}

