/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.testing.junit5.suite;

import io.helidon.logging.common.LogConfig;
import io.helidon.testing.junit5.suite.SuiteDescriptor;
import io.helidon.testing.junit5.suite.TestSuite;
import io.helidon.testing.junit5.suite.spi.SuiteProvider;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

@Deprecated
public class SuiteExtension
implements BeforeAllCallback,
ExtensionContext.Store.CloseableResource,
ParameterResolver {
    private static final System.Logger LOGGER = System.getLogger(SuiteExtension.class.getName());
    private static final Set<String> PROVIDER_KEYS = new HashSet<String>();
    private ExtensionContext.Store globalStore;
    private SuiteDescriptor descriptor;

    public SuiteExtension() {
        LogConfig.configureRuntime();
        this.globalStore = null;
    }

    public void beforeAll(ExtensionContext context) {
        if (context.getTestClass().isPresent()) {
            this.globalStore = context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
            TestSuite.Suite suite = SuiteExtension.suiteFromTestClass((Class)context.getTestClass().get());
            Class<? extends SuiteProvider> providerClass = suite.value();
            String storeKey = providerClass.getName();
            this.descriptor = SuiteExtension.providerFromStore(this.globalStore, storeKey);
            if (this.descriptor == null) {
                this.descriptor = SuiteDescriptor.create(suite, context);
                LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Initializing the Suite provider %s", providerClass.getSimpleName()));
                this.descriptor.init();
                SuiteExtension.storeProvider(this.globalStore, storeKey, this.descriptor);
                this.ensureThisInstanceIsStored(this.globalStore);
            }
        } else {
            throw new IllegalStateException("Test class was not found in jUnit 5 extension context");
        }
    }

    public void close() {
        for (String key : PROVIDER_KEYS) {
            SuiteDescriptor descriptor = (SuiteDescriptor)this.globalStore.get((Object)key, SuiteDescriptor.class);
            LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Closing Suite provider %s", descriptor.provider().getClass().getSimpleName()));
            descriptor.close();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.descriptor.supportsParameter(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.descriptor.resolveParameter(parameterContext.getParameter().getType());
    }

    private static SuiteDescriptor providerFromStore(ExtensionContext.Store globalStore, String storeKey) {
        return (SuiteDescriptor)globalStore.get((Object)storeKey, SuiteDescriptor.class);
    }

    private static void storeProvider(ExtensionContext.Store globalStore, String storeKey, SuiteDescriptor descriptor) {
        globalStore.put((Object)storeKey, (Object)descriptor);
        PROVIDER_KEYS.add(storeKey);
    }

    private static TestSuite.Suite suiteFromTestClass(Class<?> testClass) {
        TestSuite.Suite suite = testClass.getAnnotation(TestSuite.Suite.class);
        if (suite == null) {
            throw new IllegalStateException(String.format("Suite annotation was not found on %s class", testClass.getSimpleName()));
        }
        return suite;
    }

    private void ensureThisInstanceIsStored(ExtensionContext.Store globalStore) {
        if (globalStore.get((Object)SuiteExtension.class.getName()) == null) {
            globalStore.put((Object)SuiteExtension.class.getName(), (Object)this);
        }
    }
}

