/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.testing.junit5.suite;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.testing.junit5.suite.Storage;
import io.helidon.testing.junit5.suite.StorageImpl;
import io.helidon.testing.junit5.suite.SuiteResolver;
import io.helidon.testing.junit5.suite.SuiteStorage;
import io.helidon.testing.junit5.suite.TestSuite;
import io.helidon.testing.junit5.suite.spi.SuiteProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;

class SuiteDescriptor {
    private final SuiteProvider provider;
    private final Storage storage;
    private static final HelidonServiceLoader<SuiteProvider> LOADER = HelidonServiceLoader.builder(ServiceLoader.load(SuiteProvider.class)).build();

    private SuiteDescriptor(TestSuite.Suite suite, SuiteProvider provider, ExtensionContext context) {
        this.provider = provider;
        this.storage = new StorageImpl(context.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{suite.value().getName()})));
    }

    static SuiteDescriptor create(TestSuite.Suite suite, ExtensionContext context) {
        Class<? extends SuiteProvider> providerClass = suite.value();
        List<SuiteProvider> loadedProviders = LOADER.stream().filter(providerClass::isInstance).toList();
        return new SuiteDescriptor(suite, switch (loadedProviders.size()) {
            case 0 -> throw new IllegalStateException(String.format("No SuiteProvider %s instance found on the classpath", providerClass.getSimpleName()));
            case 1 -> loadedProviders.getFirst();
            default -> throw new IllegalStateException(String.format("Multiple SuiteProvider %s instances found on the classpath", providerClass.getSimpleName()));
        }, context);
    }

    boolean supportsParameter(Type type) {
        SuiteResolver resolver;
        SuiteProvider suiteProvider = this.provider;
        return suiteProvider instanceof SuiteResolver && (resolver = (SuiteResolver)((Object)suiteProvider)).supportsParameter(type) || this.provider instanceof SuiteStorage && Storage.class.isAssignableFrom((Class)type);
    }

    Object resolveParameter(Type type) {
        SuiteResolver suiteResolver;
        SuiteProvider suiteProvider = this.provider;
        if (suiteProvider instanceof SuiteResolver && (suiteResolver = (SuiteResolver)((Object)suiteProvider)).supportsParameter(type)) {
            return suiteResolver.resolveParameter(type);
        }
        if (this.provider instanceof SuiteStorage && Storage.class.isAssignableFrom((Class)type)) {
            return this.storage;
        }
        throw new IllegalArgumentException(String.format("Cannot resolve parameter Type %s", type.getTypeName()));
    }

    void init() {
        for (Method method : this.provider.getClass().getMethods()) {
            if (!method.isAnnotationPresent(TestSuite.BeforeSuite.class)) continue;
            this.callMethod(method);
        }
    }

    void close() {
        for (Method method : this.provider.getClass().getMethods()) {
            if (!method.isAnnotationPresent(TestSuite.AfterSuite.class)) continue;
            this.callMethod(method);
        }
    }

    SuiteProvider provider() {
        return this.provider;
    }

    private void callMethod(Method method) {
        Type[] types = method.getGenericParameterTypes();
        int count = method.getParameterCount();
        Object[] parameters = new Object[count];
        for (int i = 0; i < count; ++i) {
            parameters[i] = this.resolve(types[i]);
        }
        this.invoke(method, parameters);
    }

    private Object resolve(Type type) {
        Function<Type, Object> resolver = null;
        if (this.supportsParameter(type)) {
            resolver = this::resolveParameter;
            return resolver.apply(type);
        }
        throw new IllegalArgumentException(String.format("Cannot resolve parameter Type %s", type.getTypeName()));
    }

    private void invoke(Method method, Object[] parameters) {
        try {
            method.invoke((Object)this.provider, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Could not invoke %s method %s", this.provider.getClass().getSimpleName(), method.getName()), e);
        }
    }
}

