/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.telemetry.testing.tracing;

import io.helidon.common.testing.junit5.MatcherWithRetry;
import io.helidon.telemetry.testing.tracing.JsonLogConverter;
import io.opentelemetry.exporter.logging.otlp.OtlpJsonLoggingSpanExporter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class JsonLogConverterImpl
implements JsonLogConverter {
    private static final Map<String, Function<String, ?>> DATA_TYPE_MAPPERS = Map.of("intValue", Integer::parseInt, "longValue", Long::parseLong, "floatValue", Float::parseFloat, "doubleValue", Double::parseDouble, "stringValue", Function.identity());
    private final Logger logger = Logger.getLogger(OtlpJsonLoggingSpanExporter.class.getName());
    private final TestLogHandler testLogHandler = new TestLogHandler();

    JsonLogConverterImpl() {
        this.logger.addHandler(this.testLogHandler);
    }

    @Override
    public void close() throws Exception {
        this.logger.removeHandler(this.testLogHandler);
    }

    @Override
    public List<JsonLogConverter.LogResourceScopeSpans> resourceSpans(int expectedCount) {
        return (List)MatcherWithRetry.assertThatWithRetry((String)"Span infos", () -> this.testLogHandler.resourceSpans().stream().map(this::fromJson).filter(resourceScopeSpans -> !resourceScopeSpans.scopeSpans().isEmpty()).toList(), (Matcher)Matchers.hasSize((int)expectedCount));
    }

    private JsonLogConverter.LogResourceScopeSpans fromJson(String jsonText) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonText));
        JsonObject topLevelJsonObject = jsonReader.readObject();
        LogResource resource = this.resource(topLevelJsonObject);
        List<LogScopeSpans> scopeSpans = this.scopeSpansFromTopLevelJson(topLevelJsonObject);
        return new LogResourceScopeSpans(resource, scopeSpans);
    }

    private LogResource resource(JsonObject jsonObject) {
        return new LogResource(jsonObject.containsKey((Object)"resource") ? this.attributes(jsonObject.getJsonObject("resource")) : Map.of());
    }

    private Map<String, Object> attributes(JsonObject jsonObject) {
        return jsonObject.containsKey((Object)"attributes") ? (Map)jsonObject.getJsonArray("attributes").stream().map(JsonValue::asJsonObject).map(this::attribute).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), entry.getValue()), HashMap::putAll) : Map.of();
    }

    private List<LogScopeSpans> scopeSpansFromTopLevelJson(JsonObject topLevelJsonObject) {
        return topLevelJsonObject.containsKey((Object)"scopeSpans") ? topLevelJsonObject.getJsonArray("scopeSpans").stream().map(JsonValue::asJsonObject).map(this::scopeSpans).toList() : List.of();
    }

    private LogScopeSpans scopeSpans(JsonObject scopeAndSpansJsonObject) {
        return scopeAndSpansJsonObject.containsKey((Object)"scope") ? new LogScopeSpans(this.logScope(scopeAndSpansJsonObject.getJsonObject("scope")), this.logSpans(scopeAndSpansJsonObject.getJsonArray("spans"))) : new LogScopeSpans(new LogScope("empty", Map.of()), List.of());
    }

    private LogScope logScope(JsonObject scopeJsonObject) {
        return new LogScope(scopeJsonObject.getString("name", "no-name"), this.attributes(scopeJsonObject));
    }

    private List<LogSpan> logSpans(JsonArray spansJsonArray) {
        return spansJsonArray == null || spansJsonArray.isEmpty() ? List.of() : spansJsonArray.stream().map(JsonValue::asJsonObject).map(this::span).toList();
    }

    private LogSpan span(JsonObject spanJsonObject) {
        String traceId = spanJsonObject.getString("traceId");
        String spanId = spanJsonObject.getString("spanId");
        String parentSpanId = spanJsonObject.containsKey((Object)"parentSpanId") ? spanJsonObject.getString("parentSpanId") : "";
        String name = spanJsonObject.getString("name");
        int kind = spanJsonObject.getInt("kind");
        long startTimeUnixNano = Long.parseLong(spanJsonObject.getJsonString("startTimeUnixNano").getString());
        long endTimeUnixNano = Long.parseLong(spanJsonObject.getJsonString("endTimeUnixNano").getString());
        return new LogSpan(traceId, spanId, parentSpanId, name, kind, startTimeUnixNano, endTimeUnixNano, this.attributes(spanJsonObject));
    }

    private Map.Entry<String, ?> attribute(JsonObject jsonAttributeElement) {
        String key = jsonAttributeElement.getString("key");
        JsonObject value = ((JsonValue)jsonAttributeElement.get((Object)"value")).asJsonObject();
        return value.keySet().stream().map(k -> new AbstractMap.SimpleEntry(key, DATA_TYPE_MAPPERS.get(k).apply(value.getString(k)))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot convert attribute with key '%s' because the inner\nkey datatype is not recognized: %s", key, value.keySet())));
    }

    private static class TestLogHandler
    extends Handler {
        private final List<String> resourceSpans = Collections.synchronizedList(new ArrayList());

        private TestLogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            this.resourceSpans.add(record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        List<String> resourceSpans() {
            return this.resourceSpans;
        }
    }

    record LogResource(Map<String, Object> attributes) implements JsonLogConverter.LogResource
    {
    }

    static final class LogResourceScopeSpans
    extends Record
    implements JsonLogConverter.LogResourceScopeSpans {
        private final LogResource resource;
        private final List<LogScopeSpans> scopeSpans;

        LogResourceScopeSpans(LogResource resource, List<LogScopeSpans> scopeSpans) {
            this.resource = resource;
            this.scopeSpans = scopeSpans;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LogResourceScopeSpans.class, "resource;scopeSpans", "resource", "scopeSpans"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LogResourceScopeSpans.class, "resource;scopeSpans", "resource", "scopeSpans"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LogResourceScopeSpans.class, "resource;scopeSpans", "resource", "scopeSpans"}, this, o);
        }

        @Override
        public LogResource resource() {
            return this.resource;
        }

        public List<LogScopeSpans> scopeSpans() {
            return this.scopeSpans;
        }
    }

    static final class LogScopeSpans
    extends Record
    implements JsonLogConverter.LogScopeSpans {
        private final LogScope logScope;
        private final List<LogSpan> logSpans;

        LogScopeSpans(LogScope logScope, List<LogSpan> logSpans) {
            this.logScope = logScope;
            this.logSpans = logSpans;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LogScopeSpans.class, "logScope;logSpans", "logScope", "logSpans"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LogScopeSpans.class, "logScope;logSpans", "logScope", "logSpans"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LogScopeSpans.class, "logScope;logSpans", "logScope", "logSpans"}, this, o);
        }

        @Override
        public LogScope logScope() {
            return this.logScope;
        }

        public List<LogSpan> logSpans() {
            return this.logSpans;
        }
    }

    record LogScope(String name, Map<String, Object> attributes) implements JsonLogConverter.LogScope
    {
    }

    record LogSpan(String traceId, String spanId, String parentSpanId, String name, int kind, long startTimeUnixNanos, long endTimeUnixNanos, Map<String, Object> attributes) implements JsonLogConverter.LogSpan
    {
    }
}

