/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenOptions;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.codegen.FactoryAnalysisImpl;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.ServiceOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ServiceContracts {
    private static final TypeInfo OBJECT_INFO = ((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)TypeInfo.builder().typeName(TypeNames.OBJECT)).kind(ElementKind.CLASS)).accessModifier(AccessModifier.PUBLIC)).build();
    private final TypeInfo serviceInfo;
    private final Function<TypeInfo, Boolean> isEligibleInfo;
    private final Function<TypeName, Boolean> isEligibleType;
    private final Function<TypeName, Optional<TypeInfo>> typeInfoFactory;

    private ServiceContracts(Function<TypeName, Optional<TypeInfo>> typeInfoFactory, TypeInfo serviceInfo, Function<TypeInfo, Boolean> isEligibleInfo, Function<TypeName, Boolean> isEligibleType) {
        this.typeInfoFactory = typeInfoFactory;
        this.serviceInfo = serviceInfo;
        this.isEligibleInfo = isEligibleInfo;
        this.isEligibleType = isEligibleType;
    }

    public static ServiceContracts create(CodegenOptions options, Function<TypeName, Optional<TypeInfo>> typeInfoFactory, TypeInfo serviceInfo) {
        HashSet<TypeName> eligibleExternalContracts = new HashSet<TypeName>();
        ServiceContracts.eligibleContracts(eligibleExternalContracts, new HashSet<String>(), serviceInfo);
        boolean onlyAnnotatedContracts = (Boolean)ServiceOptions.AUTO_ADD_NON_CONTRACT_INTERFACES.value(options) == false;
        Set nonContractTypes = (Set)ServiceOptions.NON_CONTRACT_TYPES.value(options);
        Function<TypeInfo, Boolean> isEligibleInfo = typeInfo -> ServiceContracts.isEligible(nonContractTypes, onlyAnnotatedContracts, eligibleExternalContracts, typeInfo);
        Function<TypeName, Boolean> isEligibleType = typeName -> ServiceContracts.isEligible(typeInfoFactory, nonContractTypes, onlyAnnotatedContracts, eligibleExternalContracts, typeName);
        return new ServiceContracts(typeInfoFactory, serviceInfo, isEligibleInfo, isEligibleType);
    }

    public static TypeName requiredTypeArgument(TypeInfo typeInfo, int index) {
        Objects.requireNonNull(typeInfo);
        TypeName withGenerics = typeInfo.typeName();
        List typeArguments = withGenerics.typeArguments();
        if (typeArguments.isEmpty()) {
            throw new CodegenException("Type arguments cannot be empty for implemented interface " + String.valueOf(withGenerics), typeInfo.originatingElementValue());
        }
        if (typeArguments.size() < index + 1) {
            throw new CodegenException("There must be at least " + (index + 1) + " type arguments for implemented interface " + withGenerics.resolvedName(), typeInfo.originatingElementValue());
        }
        TypeName contract = (TypeName)typeArguments.get(index);
        if (contract.generic()) {
            throw new CodegenException("Type argument must be a concrete type for implemented interface " + String.valueOf(withGenerics), typeInfo.originatingElementValue());
        }
        return contract;
    }

    public boolean isEligible(TypeInfo contractInfo) {
        return this.isEligibleInfo.apply(contractInfo);
    }

    public boolean isEligible(TypeName contractType) {
        return this.isEligibleType.apply(contractType);
    }

    public FactoryAnalysis analyseFactory(TypeName factoryInterface) {
        Optional<TypeInfo> implementedFactory = this.serviceInfo.interfaceTypeInfo().stream().filter(it -> it.typeName().equals((Object)factoryInterface)).findFirst();
        if (implementedFactory.isEmpty()) {
            return FactoryAnalysis.create();
        }
        TypeInfo typeInfo = implementedFactory.get();
        TypeName contract = this.resolveOptional(typeInfo, ServiceContracts.requiredTypeArgument(typeInfo), factoryInterface);
        if (contract.packageName().isEmpty()) {
            contract = ((TypeName.Builder)TypeName.builder((TypeName)contract).packageName(this.serviceInfo.typeName().packageName())).build();
        }
        HashSet<ResolvedType> contracts = new HashSet<ResolvedType>();
        contracts.add(ResolvedType.create((TypeName)contract));
        TypeInfo contractInfo = ServiceContracts.contractInfo(this.typeInfoFactory, this.serviceInfo, contract);
        this.addContracts(contracts, new HashSet<ResolvedType>(), contractInfo);
        return FactoryAnalysis.create(typeInfo.typeName(), contractInfo.typeName(), contractInfo, contracts);
    }

    public void addContracts(Set<ResolvedType> contractSet, HashSet<ResolvedType> processed, TypeInfo typeInfo) {
        TypeName withGenerics = typeInfo.typeName();
        ResolvedType resolvedType = ResolvedType.create((TypeName)withGenerics);
        if (!processed.add(resolvedType)) {
            return;
        }
        if (!resolvedType.type().typeArguments().isEmpty()) {
            this.typeInfoFactory.apply(withGenerics.genericTypeName()).ifPresent(declaration -> {
                TypeName tn = declaration.typeName();
                ArrayList<TypeName> wildcards = new ArrayList<TypeName>();
                ArrayList<TypeName> extendses = new ArrayList<TypeName>();
                boolean extendsValid = false;
                for (int i = 0; i < withGenerics.typeArguments().size(); ++i) {
                    TypeName extendedType;
                    TypeName declared = (TypeName)tn.typeArguments().get(i);
                    if (!declared.generic()) continue;
                    wildcards.add(TypeNames.WILDCARD);
                    String asString = declared.toString();
                    int index = asString.indexOf(" extends ");
                    if (index == -1 || !this.isEligible(extendedType = TypeName.create((String)asString.substring(index + 9)))) continue;
                    extendses.add(extendedType);
                    extendsValid = true;
                }
                if (!wildcards.isEmpty()) {
                    contractSet.add(ResolvedType.create((TypeName)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(withGenerics)).typeArguments(wildcards)).build()));
                    if (extendsValid) {
                        contractSet.add(ResolvedType.create((TypeName)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(withGenerics)).typeArguments(extendses)).build()));
                    }
                }
            });
        }
        if (this.isEligible(typeInfo)) {
            contractSet.add(ResolvedType.create((TypeName)withGenerics));
        }
        typeInfo.superTypeInfo().ifPresent(it -> this.addContracts(contractSet, processed, (TypeInfo)it));
        typeInfo.interfaceTypeInfo().forEach(it -> this.addContracts(contractSet, processed, (TypeInfo)it));
    }

    private static TypeInfo contractInfo(Function<TypeName, Optional<TypeInfo>> typeInfoFactory, TypeInfo serviceTypeInfo, TypeName contract) {
        if (TypeNames.OBJECT.equals((Object)contract)) {
            return OBJECT_INFO;
        }
        Optional<TypeInfo> typeInfo = typeInfoFactory.apply(contract);
        if (typeInfo.isPresent()) {
            return typeInfo.get();
        }
        throw new CodegenException("Failed to discover type info for " + contract.fqName(), serviceTypeInfo.originatingElementValue());
    }

    private static TypeName requiredTypeArgument(TypeInfo typeInfo) {
        return ServiceContracts.requiredTypeArgument(typeInfo, 0);
    }

    private static boolean isEligible(Function<TypeName, Optional<TypeInfo>> typeInfoFactory, Set<TypeName> nonContractTypes, boolean onlyAnnotatedAreEligible, Set<TypeName> eligibleExternalContracts, TypeName toCheck) {
        if (eligibleExternalContracts.contains(toCheck)) {
            return true;
        }
        if (nonContractTypes.contains(toCheck)) {
            return false;
        }
        return typeInfoFactory.apply(toCheck).map(it -> ServiceContracts.isEligible(nonContractTypes, onlyAnnotatedAreEligible, eligibleExternalContracts, it)).orElse(false);
    }

    private static boolean isEligible(Set<TypeName> nonContractTypes, boolean onlyAnnotatedAreEligible, Set<TypeName> eligibleExternalContracts, TypeInfo toCheck) {
        if (eligibleExternalContracts.contains(toCheck.typeName())) {
            return true;
        }
        if (nonContractTypes.contains(toCheck.typeName())) {
            return false;
        }
        if (toCheck.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_CONTRACT)) {
            return true;
        }
        if (onlyAnnotatedAreEligible) {
            return false;
        }
        return toCheck.kind() == ElementKind.INTERFACE;
    }

    private static void eligibleContracts(Set<TypeName> eligibleContracts, Set<String> processedFullyQualified, TypeInfo typeInfo) {
        if (!processedFullyQualified.add(typeInfo.typeName().resolvedName())) {
            return;
        }
        ServiceContracts.addExternalContracts(eligibleContracts, typeInfo);
        typeInfo.superTypeInfo().ifPresent(it -> ServiceContracts.eligibleContracts(eligibleContracts, processedFullyQualified, it));
        typeInfo.interfaceTypeInfo().forEach(it -> ServiceContracts.eligibleContracts(eligibleContracts, processedFullyQualified, it));
    }

    private static void addExternalContracts(Set<TypeName> eligibleContracts, TypeInfo typeInfo) {
        typeInfo.findAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_EXTERNAL_CONTRACTS).flatMap(rec$ -> ((Annotation)rec$).typeValues()).ifPresent(eligibleContracts::addAll);
    }

    private TypeName resolveOptional(TypeInfo typeInfo, TypeName typeName, TypeName factoryInterface) {
        if (factoryInterface.equals((Object)TypeNames.SUPPLIER) && typeName.isOptional()) {
            if (typeName.typeArguments().isEmpty()) {
                throw new CodegenException("Invalid declaration of Supplier<Optional>, Optional is missing type argument", typeInfo.originatingElementValue());
            }
            return (TypeName)typeName.typeArguments().getFirst();
        }
        return typeName;
    }

    public static interface FactoryAnalysis {
        public static FactoryAnalysis create() {
            return new FactoryAnalysisImpl();
        }

        public static FactoryAnalysis create(TypeName factoryType, TypeName providedType, TypeInfo providedTypeInfo, Set<ResolvedType> providedContracts) {
            return new FactoryAnalysisImpl(factoryType, providedType, providedTypeInfo, providedContracts);
        }

        public boolean valid();

        public TypeName factoryType();

        public TypeName providedType();

        public TypeInfo providedTypeInfo();

        public Set<ResolvedType> providedContracts();
    }
}

