/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.common.Default;
import io.helidon.common.GenericType;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.codegen.DefaultsParams;
import io.helidon.service.codegen.FieldHandler;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class DefaultsCodegen {
    private static final TypeName VALUE_TYPE = TypeName.create(Default.Value.class);
    private static final TypeName INT_TYPE = TypeName.create(Default.Int.class);
    private static final TypeName DOUBLE_TYPE = TypeName.create(Default.Double.class);
    private static final TypeName BOOLEAN_TYPE = TypeName.create(Default.Boolean.class);
    private static final TypeName LONG_TYPE = TypeName.create(Default.Long.class);

    private DefaultsCodegen() {
    }

    public static Optional<DefaultCode> findDefault(Set<Annotation> annotations, TypeName targetType) {
        Optional<Annotation> found = Annotations.findFirst((TypeName)VALUE_TYPE, annotations);
        if (found.isPresent()) {
            if (targetType.equals((Object)TypeNames.STRING)) {
                return Optional.of(new DefaultCodeImpl(false, (Annotation)found.get(), targetType));
            }
            return Optional.of(new DefaultCodeImpl(true, (Annotation)found.get(), targetType));
        }
        found = Annotations.findFirst((TypeName)INT_TYPE, annotations).or(() -> Annotations.findFirst((TypeName)DOUBLE_TYPE, (Collection)annotations)).or(() -> Annotations.findFirst((TypeName)BOOLEAN_TYPE, (Collection)annotations)).or(() -> Annotations.findFirst((TypeName)LONG_TYPE, (Collection)annotations));
        return found.map(annotation -> new DefaultCodeImpl(false, (Annotation)annotation, targetType));
    }

    public static void codegenOptional(ContentBuilder<?> contentBuilder, DefaultCode defaultCode, FieldHandler constantHandler, DefaultsParams params) {
        if (defaultCode.requiresMapper()) {
            DefaultsCodegen.generateMapped(contentBuilder, defaultCode, constantHandler, params);
        } else {
            DefaultsCodegen.generateTyped(contentBuilder, defaultCode);
        }
    }

    private static void generateMapped(ContentBuilder<?> contentBuilder, DefaultCode defaultCode, FieldHandler constantHandler, DefaultsParams params) {
        String genericTypeField = constantHandler.constant("GTYPE", ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.GENERIC_TYPE).addTypeArgument(defaultCode.targetType().boxed())).build(), defaultCode.targetType(), content -> content.addContent(TypeNames.GENERIC_TYPE).addContent(".create(").addContent(defaultCode.targetType()).addContent(".class)"));
        contentBuilder.addContent(".orElseGet(() -> ").addContent(params.mappersField()).addContent(".map(\"").addContent((String)((List)defaultCode.annotation().stringValues().orElseThrow()).getFirst()).addContent("\", ").addContent(GenericType.class).addContent(".STRING, ").addContent(genericTypeField).addContent(", \"").addContent(params.mapperQualifier()).addContent("\"))");
    }

    private static void generateTyped(ContentBuilder<?> contentBuilder, DefaultCode defaultCode) {
        contentBuilder.addContent(".orElse(");
        Annotation annotation = defaultCode.annotation();
        List values = (List)annotation.stringValues().orElseThrow(() -> new CodegenException("Value is a mandatory property of all default annotations. Yet failed for: " + annotation.typeName().fqName()));
        if (values.isEmpty()) {
            throw new CodegenException("Default value is an empty array, which is not supported for code generation. Annotation: " + annotation.typeName().fqName());
        }
        String value = (String)values.getFirst();
        if (annotation.typeName().equals((Object)VALUE_TYPE)) {
            contentBuilder.addContent("\"").addContent(value).addContent("\"");
        } else {
            contentBuilder.addContent(value);
        }
        contentBuilder.addContent(")");
    }

    private record DefaultCodeImpl(boolean requiresMapper, Annotation annotation, TypeName targetType) implements DefaultCode
    {
    }

    public static interface DefaultCode {
        public boolean requiresMapper();

        public Annotation annotation();

        public TypeName targetType();
    }
}

