/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Field;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

final class Qualifiers {
    private Qualifiers() {
    }

    static Set<Annotation> qualifiers(Annotated annotated) {
        return annotated.annotations().stream().filter(it -> it.hasMetaAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_QUALIFIER)).collect(Collectors.toUnmodifiableSet());
    }

    static void generateQualifiersConstant(ClassModel.Builder classModel, Set<Annotation> qualifiers) {
        classModel.addField(qualifiersField -> ((Field.Builder)((Field.Builder)((Field.Builder)qualifiersField.isStatic(true).isFinal(true).name("QUALIFIERS")).type(ServiceCodegenTypes.SET_OF_QUALIFIERS).addContent(Set.class)).addContent(".of(").update(it -> {
            Iterator iterator = qualifiers.iterator();
            while (iterator.hasNext()) {
                Qualifiers.codeGenQualifier(it, (Annotation)iterator.next());
                if (!iterator.hasNext()) continue;
                it.addContent(", ");
            }
        })).addContent(")"));
    }

    private static void codeGenQualifier(Field.Builder field, Annotation qualifier) {
        if (qualifier.value().isPresent()) {
            ((Field.Builder)field.addContent(ServiceCodegenTypes.SERVICE_QUALIFIER).addContent(".create(").addContentCreate(qualifier.typeName())).addContent(", \"" + (String)qualifier.value().get() + "\")");
            return;
        }
        ((Field.Builder)field.addContent(ServiceCodegenTypes.SERVICE_QUALIFIER).addContent(".create(").addContentCreate(qualifier.typeName())).addContent(")");
    }
}

