/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.FilerResource;
import io.helidon.metadata.hson.Hson;
import io.helidon.service.metadata.DescriptorMetadata;
import io.helidon.service.metadata.Descriptors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class HelidonMetaInfServices {
    private final CodegenFiler filer;
    private final String resourceLocation;
    private final FilerResource services;
    private final String moduleName;
    private final Set<DescriptorMetadata> descriptors;

    private HelidonMetaInfServices(CodegenFiler filer, String resourceLocation, FilerResource services, String moduleName, Set<DescriptorMetadata> descriptors) {
        this.filer = filer;
        this.resourceLocation = resourceLocation;
        this.services = services;
        this.moduleName = moduleName;
        this.descriptors = descriptors;
    }

    public static HelidonMetaInfServices create(CodegenFiler filer, String moduleName) {
        String resourceLocation = "META-INF/helidon/" + moduleName + "/service-registry.json";
        FilerResource serviceRegistryMetadata = filer.resource(resourceLocation, new Object[0]);
        byte[] bytes = serviceRegistryMetadata.bytes();
        TreeSet<DescriptorMetadata> descriptors = new TreeSet<DescriptorMetadata>(Comparator.comparing(DescriptorMetadata::descriptorType));
        if (bytes.length != 0) {
            Hson.Array moduleRegistry = Hson.parse((InputStream)new ByteArrayInputStream(bytes)).asArray();
            descriptors.addAll(Descriptors.descriptors((String)("helidon-service-codegen for " + moduleName), (Hson.Array)moduleRegistry));
        }
        return new HelidonMetaInfServices(filer, resourceLocation, serviceRegistryMetadata, moduleName, descriptors);
    }

    public void addAll(Collection<DescriptorMetadata> services) {
        services.forEach(this::add);
    }

    public void add(DescriptorMetadata service) {
        this.descriptors.removeIf(it -> it.descriptorType().equals((Object)service.descriptorType()));
        this.descriptors.add(service);
    }

    public void write() {
        Hson.Struct.Builder root = Hson.structBuilder().set("module", this.moduleName);
        ArrayList servicesHson = new ArrayList();
        this.descriptors.stream().map(DescriptorMetadata::toHson).forEach(servicesHson::add);
        root.setStructs("services", servicesHson);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));){
            Hson.Array.create(List.of((Hson.Struct)root.build())).write(pw);
        }
        this.services.bytes(baos.toByteArray());
        this.services.write();
        this.filer.manifest().add(this.resourceLocation);
    }
}

